/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client;

import io.perfana.client.PerfanaClient;
import io.perfana.client.api.PerfanaClientLogger;
import io.perfana.client.api.PerfanaClientLoggerStdOut;
import io.perfana.client.api.PerfanaConnectionSettings;
import io.perfana.client.api.TestContext;
import io.perfana.client.exception.PerfanaClientRuntimeException;
import io.perfana.event.EventScheduleGenerator;
import io.perfana.event.PerfanaEventBroadcaster;
import io.perfana.event.PerfanaEventProperties;
import io.perfana.event.PerfanaEventProvider;
import io.perfana.event.ScheduleEvent;
import io.perfana.event.generator.EventScheduleGeneratorDefault;
import io.perfana.event.generator.EventScheduleGeneratorProvider;
import io.perfana.event.generator.GeneratorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PerfanaClientBuilder {
    private static final String GENERATOR_CLASS_META_TAG = "@generator-class";
    private TestContext testContext;
    private PerfanaConnectionSettings perfanaConnectionSettings;
    private boolean assertResultsEnabled = false;
    private PerfanaEventBroadcaster broadcaster;
    private PerfanaEventProperties eventProperties = new PerfanaEventProperties();
    private String customEventsText = "";
    private PerfanaClientLogger logger = new PerfanaClientLoggerStdOut();

    public PerfanaClientBuilder setTestContext(TestContext context) {
        this.testContext = context;
        return this;
    }

    public PerfanaClientBuilder setLogger(PerfanaClientLogger logger) {
        this.logger = logger;
        return this;
    }

    public PerfanaClientBuilder setPerfanaConnectionSettings(PerfanaConnectionSettings settings) {
        this.perfanaConnectionSettings = settings;
        return this;
    }

    public PerfanaClientBuilder setAssertResultsEnabled(boolean assertResultsEnabled) {
        this.assertResultsEnabled = assertResultsEnabled;
        return this;
    }

    public PerfanaClientBuilder setBroadcaster(PerfanaEventBroadcaster broadcaster) {
        this.broadcaster = broadcaster;
        return this;
    }

    public PerfanaClientBuilder addEventProperty(String eventImplementationName, String name, String value) {
        if (eventImplementationName == null || eventImplementationName.isEmpty()) {
            throw new PerfanaClientRuntimeException("EventImplementationName is null or empty for " + this);
        }
        if (name == null || name.isEmpty()) {
            throw new PerfanaClientRuntimeException("EventImplementation property name is null or empty for " + this);
        }
        this.eventProperties.put(eventImplementationName, name, value);
        return this;
    }

    public PerfanaClient build() {
        return this.build(null);
    }

    public PerfanaClient build(ClassLoader classLoader) {
        if (this.broadcaster == null) {
            this.logger.info("create default Perfana event broadcaster");
            this.broadcaster = PerfanaEventProvider.createInstanceWithEventsFromClasspath(this.logger, classLoader);
        }
        if (this.testContext == null) {
            throw new PerfanaClientRuntimeException("TestContext must be set, it is null.");
        }
        if (this.perfanaConnectionSettings == null) {
            throw new PerfanaClientRuntimeException("PerfanaConnectionSettings must be set, it is null.");
        }
        List<ScheduleEvent> scheduleEvents = this.generateEventSchedule(this.testContext, this.customEventsText, this.logger, classLoader);
        return new PerfanaClient(this.testContext, this.perfanaConnectionSettings, this.assertResultsEnabled, this.broadcaster, this.eventProperties, scheduleEvents, this.logger);
    }

    private List<ScheduleEvent> generateEventSchedule(TestContext context, String text, PerfanaClientLogger logger, ClassLoader classLoader) {
        GeneratorProperties generatorProperties;
        EventScheduleGenerator eventScheduleGenerator;
        if (text == null) {
            eventScheduleGenerator = new EventScheduleGeneratorDefault();
            generatorProperties = new GeneratorProperties();
        } else if (text.contains(GENERATOR_CLASS_META_TAG)) {
            generatorProperties = new GeneratorProperties(text);
            String generatorClassname = generatorProperties.getMetaProperty(GENERATOR_CLASS_META_TAG);
            eventScheduleGenerator = this.findAndCreateEventScheduleGenerator(logger, generatorClassname, classLoader);
        } else {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eventSchedule", text);
            eventScheduleGenerator = new EventScheduleGeneratorDefault();
            generatorProperties = new GeneratorProperties(properties);
        }
        List<ScheduleEvent> scheduleEvents = Collections.emptyList();
        if (eventScheduleGenerator != null) {
            scheduleEvents = eventScheduleGenerator.generateEvents(context, generatorProperties);
        }
        return scheduleEvents;
    }

    public PerfanaClientBuilder setCustomEvents(String customEventsText) {
        if (customEventsText != null) {
            this.customEventsText = customEventsText;
        }
        return this;
    }

    private EventScheduleGenerator findAndCreateEventScheduleGenerator(PerfanaClientLogger logger, String generatorClassname, ClassLoader classLoader) {
        EventScheduleGeneratorProvider provider = EventScheduleGeneratorProvider.createInstanceFromClasspath(logger, classLoader);
        EventScheduleGenerator generator = provider.find(generatorClassname);
        if (generator == null) {
            throw new PerfanaClientRuntimeException("unable to find EventScheduleGenerator implementation class: " + generatorClassname);
        }
        return generator;
    }
}

