/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event;

import io.perfana.client.PerfanaClientRuntimeException;
import java.time.Duration;

public class ScheduleEvent {
    private Duration duration;
    private String name;
    private String settings;

    public ScheduleEvent(Duration duration, String name, String settings) {
        this.duration = duration;
        this.name = name;
        this.settings = settings;
    }

    public ScheduleEvent(Duration duration, String name) {
        this.duration = duration;
        this.name = name;
        this.settings = null;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public String getName() {
        return this.name;
    }

    public String getSettings() {
        return this.settings;
    }

    public static ScheduleEvent createFromLine(String line) {
        Duration duration;
        String[] elements = line.split("\\|");
        if (elements.length != 2 && elements.length != 3) {
            throw new PerfanaClientRuntimeException("Wrong number of elements in line, expected 2 or 3 separated by '|': " + line);
        }
        try {
            duration = Duration.parse(elements[0]);
        }
        catch (Exception e) {
            throw new PerfanaClientRuntimeException("Failed to parse duration: " + elements[0] + " from line: " + line, e);
        }
        String name = elements[1];
        if (elements.length == 2) {
            return new ScheduleEvent(duration, name);
        }
        return new ScheduleEvent(duration, name, elements[2]);
    }

    public String toString() {
        return String.format("ScheduleEvent %s [duration=%s settings=%s]", this.name, this.duration, this.settings);
    }
}

