/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client;

import io.perfana.client.PerfanaClient;
import io.perfana.client.PerfanaClientRuntimeException;
import io.perfana.event.PerfanaEventBroadcaster;
import io.perfana.event.PerfanaEventProperties;
import io.perfana.event.PerfanaEventProvider;
import io.perfana.event.ScheduleEvent;
import java.io.BufferedReader;
import java.io.StringReader;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class PerfanaClientBuilder {
    private static final int DEFAULT_RAMPUP_TIME_SECONDS = 0;
    private static final int DEFAULT_CONSTANT_LOAD_TIME_SECONDS = 600;
    private static final int DEFAULT_KEEP_ALIVE_TIME_SECONDS = 30;
    private static final int DEFAULT_RETRY_TIME_SECONDS = 10;
    private static final int DEFAULT_RETRY_MAX_COUNT = 30;
    private String application = "unknown";
    private String testType = "unknown";
    private String testEnvironment = "unknown";
    private String testRunId = "unknown_" + System.currentTimeMillis();
    private String ciBuildResultsUrl = "unknown";
    private String applicationRelease = "unknown";
    private Duration rampupTime = Duration.ofSeconds(0L);
    private Duration constantLoadTime = Duration.ofSeconds(600L);
    private String perfanaUrl = "unknown";
    private String annotations = "";
    private Duration keepAliveTime = Duration.ofSeconds(30L);
    private int retryMaxCount = 30;
    private Duration retryDuration = Duration.ofSeconds(10L);
    private Map<String, String> variables = Collections.emptyMap();
    private boolean assertResultsEnabled = false;
    private PerfanaEventBroadcaster broadcaster;
    private PerfanaEventProperties eventProperties = new PerfanaEventProperties();
    private List<ScheduleEvent> scheduleEvents = Collections.emptyList();
    private PerfanaClient.Logger logger = new PerfanaClient.Logger(){

        @Override
        public void info(String message) {
            this.say("INFO ", message);
        }

        @Override
        public void warn(String message) {
            this.say("WARN ", message);
        }

        @Override
        public void error(String message) {
            this.say("ERROR", message);
        }

        @Override
        public void debug(String message) {
            this.say("DEBUG", message);
        }

        private void say(String level, String something) {
            System.out.printf("[%s] %s%n", level, something);
        }
    };

    public PerfanaClientBuilder setApplication(String application) {
        this.application = application;
        return this;
    }

    public PerfanaClientBuilder setTestType(String testType) {
        this.testType = testType;
        return this;
    }

    public PerfanaClientBuilder setTestEnvironment(String testEnvironment) {
        this.testEnvironment = testEnvironment;
        return this;
    }

    public PerfanaClientBuilder setTestRunId(String testRunId) {
        this.testRunId = testRunId;
        return this;
    }

    public PerfanaClientBuilder setCIBuildResultsUrl(String ciBuildResultsUrl) {
        this.ciBuildResultsUrl = ciBuildResultsUrl;
        return this;
    }

    public PerfanaClientBuilder setApplicationRelease(String applicationRelease) {
        this.applicationRelease = applicationRelease;
        return this;
    }

    public PerfanaClientBuilder setRampupTimeInSeconds(String rampupTimeInSeconds) {
        this.rampupTime = Duration.ofSeconds(this.parseInt("rampupTime", rampupTimeInSeconds, 0));
        return this;
    }

    public PerfanaClientBuilder setConstantLoadTimeInSeconds(String constantLoadTimeInSeconds) {
        this.constantLoadTime = Duration.ofSeconds(this.parseInt("constantLoadTime", constantLoadTimeInSeconds, 600));
        return this;
    }

    public PerfanaClientBuilder setPerfanaUrl(String perfanaUrl) {
        this.perfanaUrl = perfanaUrl;
        return this;
    }

    public PerfanaClientBuilder setAnnotations(String annotations) {
        this.annotations = annotations;
        return this;
    }

    @Deprecated
    public PerfanaClientBuilder setVariables(Properties variables) {
        HashMap<String, String> keyValueMap = new HashMap<String, String>(variables.size(), 1.0f);
        variables.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> keyValueMap.put((String)key, (String)value)));
        this.variables = keyValueMap;
        return this;
    }

    public PerfanaClientBuilder setVariables(Map<String, String> variables) {
        this.variables = variables;
        return this;
    }

    public PerfanaClientBuilder setAssertResultsEnabled(boolean assertResultsEnabled) {
        this.assertResultsEnabled = assertResultsEnabled;
        return this;
    }

    public PerfanaClientBuilder setLogger(PerfanaClient.Logger logger) {
        this.logger = logger;
        return this;
    }

    public PerfanaClientBuilder setBroadcaster(PerfanaEventBroadcaster broadcaster) {
        this.broadcaster = broadcaster;
        return this;
    }

    public PerfanaClientBuilder setKeepAliveTimeInSeconds(String keepAliveTimeInSeconds) {
        this.keepAliveTime = Duration.ofSeconds(this.parseInt("keepAliveTimeInSeconds", keepAliveTimeInSeconds, 30));
        return this;
    }

    public PerfanaClientBuilder setRetryMaxCount(String retryMaxCount) {
        this.retryMaxCount = this.parseInt("retryMaxCount", retryMaxCount, 30);
        return this;
    }

    public PerfanaClientBuilder setRetryTimeInSeconds(String retryTimeInSeconds) {
        this.retryDuration = Duration.ofSeconds(this.parseInt("retryTimeInSeconds", retryTimeInSeconds, 10));
        return this;
    }

    public PerfanaClientBuilder addEventProperty(String eventImplementationName, String name, String value) {
        if (eventImplementationName == null || eventImplementationName.isEmpty()) {
            throw new PerfanaClientRuntimeException("EventImplementationName is null or empty for " + this);
        }
        if (name == null || name.isEmpty()) {
            throw new PerfanaClientRuntimeException("EventImplementation property name is null or empty for " + this);
        }
        this.eventProperties.put(eventImplementationName, name, value);
        return this;
    }

    public PerfanaClient createPerfanaClient() {
        if (this.broadcaster == null) {
            this.logger.info("Creating default Perfana event broadcaster.");
        }
        PerfanaEventBroadcaster broadcaster = this.broadcaster == null ? PerfanaEventProvider.getInstance() : this.broadcaster;
        PerfanaClient perfanaClient = new PerfanaClient(this.application, this.testType, this.testEnvironment, this.testRunId, this.ciBuildResultsUrl, this.applicationRelease, this.rampupTime, this.constantLoadTime, this.perfanaUrl, this.annotations, this.variables, this.assertResultsEnabled, broadcaster, this.eventProperties, this.retryMaxCount, this.retryDuration, this.keepAliveTime, this.scheduleEvents);
        perfanaClient.injectLogger(this.logger);
        return perfanaClient;
    }

    private int parseInt(String variableName, String timeString) {
        return this.parseInt(variableName, timeString, 0);
    }

    private int parseInt(String variableName, String timeString, int defaultValue) {
        int time;
        try {
            time = Integer.parseInt(timeString);
        }
        catch (NumberFormatException e) {
            this.logger.error(String.format("Unable to parse value of [%s=%s]: using default value [%d]. Error message: %s.", variableName, timeString, defaultValue, e.getMessage()));
            time = defaultValue;
        }
        return time;
    }

    public PerfanaClientBuilder setScheduleEvents(String eventSchedule) {
        BufferedReader eventReader = new BufferedReader(new StringReader(eventSchedule));
        return this.setScheduleEvents(eventReader.lines().collect(Collectors.toList()));
    }

    public PerfanaClientBuilder setScheduleEvents(List<String> scheduleEvents) {
        this.scheduleEvents = this.parseScheduleEvents(scheduleEvents);
        return this;
    }

    private List<ScheduleEvent> parseScheduleEvents(List<String> eventSchedule) {
        return eventSchedule.stream().map(ScheduleEvent::createFromLine).collect(Collectors.toList());
    }
}

