/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event;

import io.perfana.event.PerfanaEventBroadcaster;
import io.perfana.event.PerfanaEventProperties;
import io.perfana.event.PerfanaTestEvent;
import java.util.ServiceLoader;

public class PerfanaEventProvider
implements PerfanaEventBroadcaster {
    private static PerfanaEventProvider eventProvider = new PerfanaEventProvider();
    private ServiceLoader<PerfanaTestEvent> perfanaEventLoader = ServiceLoader.load(PerfanaTestEvent.class);

    private PerfanaEventProvider() {
    }

    public static PerfanaEventProvider getInstance() {
        return eventProvider;
    }

    @Override
    public void broadcastBeforeTest(String testId, PerfanaEventProperties properties) {
        this.perfanaEventLoader.forEach(event -> event.beforeTest(testId, properties.get((PerfanaTestEvent)event)));
    }

    @Override
    public void broadcastAfterTest(String testId, PerfanaEventProperties properties) {
        this.perfanaEventLoader.forEach(event -> event.afterTest(testId, properties.get((PerfanaTestEvent)event)));
    }

    @Override
    public void broadcastFailover(String testId, PerfanaEventProperties properties) {
        this.perfanaEventLoader.forEach(event -> event.failover(testId, properties.get((PerfanaTestEvent)event)));
    }

    @Override
    public void broadCastKeepAlive(String testId, PerfanaEventProperties properties) {
        this.perfanaEventLoader.forEach(event -> event.keepAlive(testId, properties.get((PerfanaTestEvent)event)));
    }
}

