/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import io.perfana.client.PerfanaClientException;
import io.perfana.event.PerfanaEventBroadcaster;
import io.perfana.event.PerfanaEventProperties;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class PerfanaClient {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient client = new OkHttpClient();
    private final PerfanaEventBroadcaster broadcaster;
    private final PerfanaEventProperties eventProperties;
    private Logger logger;
    private final String application;
    private final String testType;
    private final String testEnvironment;
    private final String testRunId;
    private final String CIBuildResultsUrl;
    private final String applicationRelease;
    private final String perfanaUrl;
    private final String rampupTimeSeconds;
    private final int plannedDurationInSeconds;
    private final String annotations;
    private final Properties variables;
    private final boolean assertResultsEnabled;
    private ScheduledExecutorService executor;

    PerfanaClient(String application, String testType, String testEnvironment, String testRunId, String CIBuildResultsUrl, String applicationRelease, String rampupTimeInSeconds, String constantLoadTimeInSeconds, String perfanaUrl, String annotations, Properties variables, boolean assertResultsEnabled, PerfanaEventBroadcaster broadcaster, PerfanaEventProperties eventProperties) {
        this.application = application;
        this.testType = testType;
        this.testEnvironment = testEnvironment;
        this.testRunId = testRunId;
        this.CIBuildResultsUrl = CIBuildResultsUrl;
        this.applicationRelease = applicationRelease;
        this.rampupTimeSeconds = rampupTimeInSeconds;
        this.plannedDurationInSeconds = PerfanaClient.parseIntNullIsZero(rampupTimeInSeconds) + PerfanaClient.parseIntNullIsZero(constantLoadTimeInSeconds);
        this.perfanaUrl = perfanaUrl;
        this.annotations = annotations;
        this.variables = variables;
        this.assertResultsEnabled = assertResultsEnabled;
        this.broadcaster = broadcaster;
        this.eventProperties = eventProperties;
    }

    public void startSession() {
        this.logger.info("Perfana start session");
        this.logger.info("Perfana broadcast event before test");
        this.broadcaster.broadcastBeforeTest(this.testRunId, this.eventProperties);
        if (this.executor != null) {
            throw new RuntimeException("Cannot start perfana session multiple times!");
        }
        int periodInSeconds = 15;
        this.logger.info(String.format("Calling Perfana (%s) keep alive every %d seconds.", this.perfanaUrl, 15));
        this.executor = Executors.newSingleThreadScheduledExecutor();
        KeepAliveRunner keepAliveRunner = new KeepAliveRunner(this);
        this.executor.scheduleAtFixedRate(keepAliveRunner, 0L, 15L, TimeUnit.SECONDS);
        int rampupTimeSeconds = this.parseRampupTime();
        long failoverSleepInSeconds = (long)rampupTimeSeconds + TimeUnit.MINUTES.toSeconds(5L);
        this.logger.info("Failover event is scheduled to run in " + failoverSleepInSeconds + " seconds. This is the rampup time plus 5 minutes.");
        FailoverRunner failoverRunner = new FailoverRunner(this);
        this.executor.schedule(failoverRunner, failoverSleepInSeconds, TimeUnit.SECONDS);
    }

    private int parseRampupTime() {
        int rampupTime;
        try {
            rampupTime = Integer.parseInt(this.rampupTimeSeconds);
        }
        catch (NumberFormatException e) {
            this.logger.error("Unable to parse rampupTimeSeconds, will use 0 as rampup time. " + e.getMessage());
            rampupTime = 0;
        }
        return rampupTime;
    }

    public void stopSession() throws PerfanaClientException {
        this.logger.info("Perfana end session.");
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.executor = null;
        this.logger.info("Perfana broadcast event after test");
        this.broadcaster.broadcastAfterTest(this.testRunId, this.eventProperties);
        this.callPerfana(true);
        this.assertResults();
    }

    private static int parseIntNullIsZero(String value) {
        return value == null ? 0 : Integer.valueOf(value);
    }

    void injectLogger(Logger logger) {
        this.logger = logger;
    }

    private void callPerfana(Boolean completed) {
        String json = this.perfanaJson(this.application, this.testType, this.testEnvironment, this.testRunId, this.CIBuildResultsUrl, this.applicationRelease, this.rampupTimeSeconds, this.plannedDurationInSeconds, this.annotations, this.variables, completed);
        this.logger.debug(String.join((CharSequence)" ", "Call to endpoint:", this.perfanaUrl, "with json:", json));
        try {
            String result = this.post(this.perfanaUrl + "/test", json);
            this.logger.debug("Result: " + result);
        }
        catch (IOException e) {
            this.logger.error("Failed to call perfana: " + e.getMessage());
        }
    }

    private String post(String url, String json) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody responseBody = response.body();
            String string = responseBody == null ? "null" : responseBody.string();
            return string;
        }
    }

    private String perfanaJson(String application, String testType, String testEnvironment, String testRunId, String CIBuildResultsUrl, String applicationRelease, String rampupTimeSeconds, int plannedDurationInSeconds, String annotations, Properties variables, Boolean completed) {
        JSONObject perfanaJson = new JSONObject();
        if (variables != null && !variables.isEmpty()) {
            JSONArray variablesArrayJson = new JSONArray();
            Enumeration<?> enumeration = variables.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String value = (String)variables.get(name);
                JSONObject variablesJson = new JSONObject();
                variablesJson.put((Object)"placeholder", (Object)name);
                variablesJson.put((Object)"value", (Object)value);
                variablesArrayJson.add((Object)variablesJson);
            }
            perfanaJson.put((Object)"variables", (Object)variablesArrayJson);
        }
        if (!"".equals(annotations) && annotations != null) {
            perfanaJson.put((Object)"annotations", (Object)annotations);
        }
        perfanaJson.put((Object)"testRunId", (Object)testRunId);
        perfanaJson.put((Object)"testType", (Object)testType);
        perfanaJson.put((Object)"testEnvironment", (Object)testEnvironment);
        perfanaJson.put((Object)"application", (Object)application);
        perfanaJson.put((Object)"applicationRelease", (Object)applicationRelease);
        perfanaJson.put((Object)"CIBuildResultsUrl", (Object)CIBuildResultsUrl);
        perfanaJson.put((Object)"rampUp", (Object)rampupTimeSeconds);
        perfanaJson.put((Object)"duration", (Object)String.valueOf(plannedDurationInSeconds));
        perfanaJson.put((Object)"completed", (Object)completed);
        return perfanaJson.toJSONString();
    }

    private String callCheckAsserts() throws PerfanaClientException {
        String url;
        try {
            url = String.join((CharSequence)"/", this.perfanaUrl, "get-benchmark-results", URLEncoder.encode(this.application, "UTF-8").replaceAll("\\+", "%20"), URLEncoder.encode(this.testRunId, "UTF-8").replaceAll("\\+", "%20"));
        }
        catch (UnsupportedEncodingException e) {
            throw new PerfanaClientException("Cannot encode perfana url.", e);
        }
        Request request = new Request.Builder().url(url).get().build();
        int retryCount = 0;
        int MAX_RETRIES = 12;
        long sleepInMillis = 10000L;
        String assertions = null;
        boolean assertionsAvailable = false;
        while (retryCount++ < 12) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                Response response = this.client.newCall(request).execute();
                Throwable throwable = null;
                try {
                    ResponseBody responseBody = response.body();
                    if (response.code() == 200) {
                        assertions = responseBody == null ? "null" : responseBody.string();
                        assertionsAvailable = true;
                        break;
                    }
                    String message = responseBody == null ? response.message() : responseBody.string();
                    this.logger.info(String.format("failed to retrieve assertions for url [%s] code [%d] retry [%d/%d] %s", url, response.code(), retryCount, 12, message));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (IOException e) {
                throw new PerfanaClientException(String.format("Unable to retrieve assertions for url [%s]", url), e);
            }
        }
        if (!assertionsAvailable) {
            this.logger.warn(String.format("Failed to retrieve assertions for url [%s], no more retries left!", url));
            throw new PerfanaClientException(String.format("Unable to retrieve assertions for url [%s]", url));
        }
        return assertions;
    }

    private String assertResults() throws PerfanaClientException {
        if (!this.assertResultsEnabled) {
            String message = "Perfana assert results is not enabled.";
            this.logger.info(message);
            return message;
        }
        String assertions = this.callCheckAsserts();
        if (assertions == null) {
            throw new PerfanaClientException("Perfana assertions could not be checked, received null.");
        }
        Configuration config = Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
        ParseContext parseContext = JsonPath.using((Configuration)config);
        DocumentContext documentContext = parseContext.parse(assertions);
        Boolean benchmarkBaselineTestRunResult = (Boolean)documentContext.read("$.benchmarkBaselineTestRun.result", new Predicate[0]);
        String benchmarkBaselineTestRunDeeplink = (String)documentContext.read("$.benchmarkBaselineTestRun.deeplink", new Predicate[0]);
        Boolean benchmarkPreviousTestRunResult = (Boolean)documentContext.read("$.benchmarkPreviousTestRun.result", new Predicate[0]);
        String benchmarkPreviousTestRunDeeplink = (String)documentContext.read("$.benchmarkPreviousTestRun.deeplink", new Predicate[0]);
        Boolean requirementsResult = (Boolean)documentContext.read("$.requirements.result", new Predicate[0]);
        String requirementsDeeplink = (String)documentContext.read("$.requirements.deeplink", new Predicate[0]);
        this.logger.info(String.format("benchmarkBaselineTestRunResult: %s", benchmarkBaselineTestRunResult));
        this.logger.info(String.format("benchmarkPreviousTestRunResult: %s", benchmarkPreviousTestRunResult));
        this.logger.info(String.format("requirementsResult: %s", requirementsResult));
        StringBuilder text = new StringBuilder();
        if (assertions.contains("false")) {
            text.append("One or more Perfana assertions are failing: \n");
            if (requirementsResult != null && !requirementsResult.booleanValue()) {
                text.append(String.format("Requirements failed: %s\n", requirementsDeeplink));
            }
            if (benchmarkPreviousTestRunResult != null && !benchmarkPreviousTestRunResult.booleanValue()) {
                text.append(String.format("Benchmark to previous test run failed: %s\n", benchmarkPreviousTestRunDeeplink));
            }
            if (benchmarkBaselineTestRunResult != null && !benchmarkBaselineTestRunResult.booleanValue()) {
                text.append(String.format("Benchmark to baseline test run failed: %s", benchmarkBaselineTestRunDeeplink));
            }
            this.logger.info(String.format("assertionText: %s", text));
            throw new PerfanaClientException(text.toString());
        }
        text.append("All Perfana assertions are OK: \n");
        if (requirementsResult.booleanValue()) {
            text.append(requirementsDeeplink).append("\n");
        }
        if (benchmarkPreviousTestRunResult != null && benchmarkPreviousTestRunResult.booleanValue()) {
            text.append(benchmarkPreviousTestRunDeeplink).append("\n");
        }
        if (benchmarkBaselineTestRunResult != null && benchmarkBaselineTestRunResult.booleanValue()) {
            text.append(benchmarkBaselineTestRunDeeplink);
        }
        this.logger.info(String.format("The assertionText: %s", text));
        return text.toString();
    }

    public static interface Logger {
        public void info(String var1);

        public void warn(String var1);

        public void error(String var1);

        public void debug(String var1);
    }

    public static class FailoverRunner
    implements Runnable {
        private final PerfanaClient client;

        FailoverRunner(PerfanaClient client) {
            this.client = client;
        }

        @Override
        public void run() {
            this.client.logger.info("Perfana broadcast event failover");
            this.client.broadcaster.broadcastFailover(this.client.testRunId, this.client.eventProperties);
        }
    }

    public static class KeepAliveRunner
    implements Runnable {
        private final PerfanaClient client;

        KeepAliveRunner(PerfanaClient client) {
            this.client = client;
        }

        @Override
        public void run() {
            this.client.callPerfana(false);
            this.client.broadcaster.broadCastKeepAlive(this.client.testRunId, this.client.eventProperties);
        }
    }
}

