/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client;

import io.perfana.client.PerfanaClient;
import java.util.Properties;

public class PerfanaClientBuilder {
    private String application = "unknown";
    private String testType = "unknown";
    private String testEnvironment = "unknown";
    private String testRunId = "unknown";
    private String ciBuildResultsUrl = "unknown";
    private String applicationRelease = "unknown";
    private String rampupTimeInSeconds = "0";
    private String constantLoadTimeInSeconds = "0";
    private String perfanaUrl = "unknown";
    private String annotations = "";
    private Properties variables = new Properties();
    private boolean assertResultsEnabled = false;
    private PerfanaClient.Logger logger = new PerfanaClient.Logger(){

        @Override
        public void info(String message) {
            System.out.println("INFO:  " + message);
        }

        @Override
        public void warn(String message) {
            System.out.println("WARN:  " + message);
        }

        @Override
        public void error(String message) {
            System.out.println("ERROR: " + message);
        }

        @Override
        public void debug(String message) {
            System.out.println("DEBUG: " + message);
        }
    };

    public PerfanaClientBuilder setApplication(String application) {
        this.application = application;
        return this;
    }

    public PerfanaClientBuilder setTestType(String testType) {
        this.testType = testType;
        return this;
    }

    public PerfanaClientBuilder setTestEnvironment(String testEnvironment) {
        this.testEnvironment = testEnvironment;
        return this;
    }

    public PerfanaClientBuilder setTestRunId(String testRunId) {
        this.testRunId = testRunId;
        return this;
    }

    public PerfanaClientBuilder setCIBuildResultsUrl(String ciBuildResultsUrl) {
        this.ciBuildResultsUrl = ciBuildResultsUrl;
        return this;
    }

    public PerfanaClientBuilder setApplicationRelease(String applicationRelease) {
        this.applicationRelease = applicationRelease;
        return this;
    }

    public PerfanaClientBuilder setRampupTimeInSeconds(String rampupTimeInSeconds) {
        this.rampupTimeInSeconds = rampupTimeInSeconds;
        return this;
    }

    public PerfanaClientBuilder setConstantLoadTimeInSeconds(String constantLoadTimeInSeconds) {
        this.constantLoadTimeInSeconds = constantLoadTimeInSeconds;
        return this;
    }

    public PerfanaClientBuilder setPerfanaUrl(String perfanaUrl) {
        this.perfanaUrl = perfanaUrl;
        return this;
    }

    public PerfanaClientBuilder setAnnotations(String annotations) {
        this.annotations = annotations;
        return this;
    }

    public PerfanaClientBuilder setVariables(Properties variables) {
        this.variables = variables;
        return this;
    }

    public PerfanaClientBuilder setAssertResultsEnabled(boolean assertResultsEnabled) {
        this.assertResultsEnabled = assertResultsEnabled;
        return this;
    }

    public PerfanaClientBuilder setLogger(PerfanaClient.Logger logger) {
        this.logger = logger;
        return this;
    }

    public PerfanaClient createPerfanaClient() {
        PerfanaClient perfanaClient = new PerfanaClient(this.application, this.testType, this.testEnvironment, this.testRunId, this.ciBuildResultsUrl, this.applicationRelease, this.rampupTimeInSeconds, this.constantLoadTimeInSeconds, this.perfanaUrl, this.annotations, this.variables, this.assertResultsEnabled);
        perfanaClient.injectLogger(this.logger);
        return perfanaClient;
    }
}

