/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.maven.plugin.MojoExecutionException;

public class PerfanaClient {
    private Logger logger = new SystemOutLogger();
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient client = new OkHttpClient();
    private final String application;
    private final String testType;
    private final String testEnvironment;
    private final String testRunId;
    private final String CIBuildResultsUrl;
    private final String applicationRelease;
    private final String perfanaUrl;
    private final String rampupTimeSeconds;
    private final String plannedDurationInSeconds;
    private final String annotations;
    private final Properties variables;

    public PerfanaClient(String application, String testType, String testEnvironment, String testRunId, String CIBuildResultsUrl, String applicationRelease, String rampupTimeInSeconds, String constantLoadTimeInSeconds, String perfanaUrl, String annotations, Properties variables) {
        this.application = application;
        this.testType = testType;
        this.testEnvironment = testEnvironment;
        this.testRunId = testRunId;
        this.CIBuildResultsUrl = CIBuildResultsUrl;
        this.applicationRelease = applicationRelease;
        this.rampupTimeSeconds = rampupTimeInSeconds;
        this.plannedDurationInSeconds = String.valueOf(Integer.parseInt(rampupTimeInSeconds) + Integer.parseInt(constantLoadTimeInSeconds));
        this.perfanaUrl = perfanaUrl;
        this.annotations = annotations;
        this.variables = variables;
    }

    public void injectLogger(Logger logger) {
        this.logger = logger;
    }

    public void callPerfana(Boolean completed) {
        String json = this.perfanaJson(this.application, this.testType, this.testEnvironment, this.testRunId, this.CIBuildResultsUrl, this.applicationRelease, this.rampupTimeSeconds, this.plannedDurationInSeconds, this.annotations, this.variables, completed);
        this.logger.debug(String.join((CharSequence)" ", "Call to endpoint:", this.perfanaUrl, "with json:", json));
        try {
            String result = this.post(this.perfanaUrl + "/test", json);
            this.logger.debug("Result: " + result);
        }
        catch (IOException e) {
            this.logger.error("Failed to call perfana: " + e.getMessage());
        }
    }

    private String post(String url, String json) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody responseBody = response.body();
            String string = responseBody == null ? "null" : responseBody.string();
            return string;
        }
    }

    private String perfanaJson(String application, String testType, String testEnvironment, String testRunId, String CIBuildResultsUrl, String applicationRelease, String rampupTimeSeconds, String plannedDurationInSeconds, String annotations, Properties variables, Boolean completed) {
        JSONObject perfanaJson = new JSONObject();
        if (variables != null && !variables.isEmpty()) {
            JSONArray variablesArrayJson = new JSONArray();
            Enumeration<?> enumeration = variables.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String value = (String)variables.get(name);
                JSONObject variablesJson = new JSONObject();
                variablesJson.put((Object)"placeholder", (Object)name);
                variablesJson.put((Object)"value", (Object)value);
                variablesArrayJson.add((Object)variablesJson);
            }
            perfanaJson.put((Object)"variables", (Object)variablesArrayJson);
        }
        if (!"".equals(annotations) && annotations != null) {
            perfanaJson.put((Object)"annotations", (Object)annotations);
        }
        perfanaJson.put((Object)"testRunId", (Object)testRunId);
        perfanaJson.put((Object)"testType", (Object)testType);
        perfanaJson.put((Object)"testEnvironment", (Object)testEnvironment);
        perfanaJson.put((Object)"application", (Object)application);
        perfanaJson.put((Object)"applicationRelease", (Object)applicationRelease);
        perfanaJson.put((Object)"CIBuildResultsUrl", (Object)CIBuildResultsUrl);
        perfanaJson.put((Object)"rampUp", (Object)rampupTimeSeconds);
        perfanaJson.put((Object)"duration", (Object)plannedDurationInSeconds);
        perfanaJson.put((Object)"completed", (Object)completed);
        return perfanaJson.toJSONString();
    }

    public String callCheckAsserts() throws IOException, MojoExecutionException {
        String url = String.join((CharSequence)"/", this.perfanaUrl, "get-benchmark-results", URLEncoder.encode(this.application, "UTF-8").replaceAll("\\+", "%20"), URLEncoder.encode(this.testRunId, "UTF-8").replaceAll("\\+", "%20"));
        Request request = new Request.Builder().url(url).get().build();
        int retries = 0;
        int MAX_RETRIES = 30;
        long sleepInMillis = 10000L;
        String assertions = null;
        while (retries <= 30) {
            try (Response response = this.client.newCall(request).execute();){
                ResponseBody responseBody = response.body();
                if (response.code() == 200) {
                    assertions = responseBody == null ? "null" : responseBody.string();
                    break;
                }
                String message = responseBody == null ? response.message() : responseBody.string();
                this.logger.warn("failed to retrieve assertions for url [" + url + "] code [" + response.code() + "] retry [" + retries + "/" + 30 + "] " + message);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (++retries != 30) continue;
            throw new MojoExecutionException("Unable to retrieve assertions for url [" + url + "]");
        }
        return assertions;
    }

    public static class SystemOutLogger
    implements Logger {
        @Override
        public void info(String message) {
            System.out.println("INFO:  " + message);
        }

        @Override
        public void warn(String message) {
            System.out.println("WARN:  " + message);
        }

        @Override
        public void error(String message) {
            System.out.println("ERROR: " + message);
        }

        @Override
        public void debug(String message) {
            System.out.println("DEBUG: " + message);
        }
    }

    public static interface Logger {
        public void info(String var1);

        public void warn(String var1);

        public void error(String var1);

        public void debug(String var1);
    }

    public static class KeepAliveRunner
    implements Runnable {
        private final PerfanaClient client;

        public KeepAliveRunner(PerfanaClient client) {
            this.client = client;
        }

        @Override
        public void run() {
            this.client.callPerfana(false);
        }
    }
}

