/*
 * Decompiled with CFR 0.152.
 */
package com.internetitem.logback.elasticsearch;

import com.internetitem.logback.elasticsearch.config.Settings;
import com.internetitem.logback.elasticsearch.util.ErrorReporter;
import com.internetitem.logback.elasticsearch.writer.SafeWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ElasticsearchOutputAggregator
extends Writer {
    private Settings settings;
    private ErrorReporter errorReporter;
    private List<SafeWriter> writers = new ArrayList<SafeWriter>();

    public ElasticsearchOutputAggregator(Settings settings, ErrorReporter errorReporter) {
        this.settings = settings;
        this.errorReporter = errorReporter;
    }

    public void addWriter(SafeWriter writer) {
        this.writers.add(writer);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (SafeWriter writer : this.writers) {
            writer.write(cbuf, off, len);
        }
    }

    public boolean hasPendingData() {
        for (SafeWriter writer : this.writers) {
            if (!writer.hasPendingData()) continue;
            return true;
        }
        return false;
    }

    public boolean hasOutputs() {
        return !this.writers.isEmpty();
    }

    public boolean sendData() {
        boolean success = true;
        for (SafeWriter writer : this.writers) {
            try {
                writer.sendData();
            }
            catch (IOException e) {
                success = false;
                this.errorReporter.logWarning("Failed to send events to Elasticsearch: " + e.getMessage());
                if (!this.settings.isErrorsToStderr()) continue;
                System.err.println("[" + new Date().toString() + "] Failed to send events to Elasticsearch: " + e.getMessage());
            }
        }
        return success;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

