/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.results;

import com.lazerycode.jmeter.results.CSVFileScanner;
import com.lazerycode.jmeter.results.CSVScanResult;
import com.lazerycode.jmeter.results.IResultScanner;
import com.lazerycode.jmeter.results.XMLFileScanner;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultScanner
implements IResultScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultScanner.class);
    private static final String XML_REQUEST_FAILURE_PATTERN = "s=\"false\"";
    private static final String XML_REQUEST_SUCCESS_PATTERN = "s=\"true\"";
    private final boolean countFailures;
    private final boolean countSuccesses;
    private final boolean onlyFailWhenMatchingFailureMessage;
    private final boolean csv;
    private final List<String> failureMessages;
    private int successCount = 0;
    private int failureCount = 0;
    private int customFailureCount = 0;

    public ResultScanner(boolean countSuccesses, boolean countFailures, boolean isCsv, boolean onlyFailWhenMatchingFailureMessage, List<String> failureMessages) {
        this.csv = isCsv;
        this.countFailures = countFailures;
        this.countSuccesses = countSuccesses;
        this.onlyFailWhenMatchingFailureMessage = onlyFailWhenMatchingFailureMessage;
        this.failureMessages = failureMessages;
    }

    public void parseResultFile(File file) throws MojoExecutionException {
        if (!file.exists()) {
            throw new MojoExecutionException("Unable to find " + file.getAbsolutePath());
        }
        LOGGER.info(" ");
        LOGGER.info("Parsing results file '{}' as type: {}", (Object)file, (Object)(this.csv ? "CSV" : "XML"));
        if (this.csv) {
            CSVScanResult csvScanResult = CSVFileScanner.scanCsvForValues(file, this.failureMessages);
            this.successCount += csvScanResult.getSuccessCount();
            this.failureCount += csvScanResult.getFailureCount();
            for (Map.Entry<String, Integer> entry : csvScanResult.getSpecificFailureMessages().entrySet()) {
                this.customFailureCount += entry.getValue().intValue();
                LOGGER.info("Number of potential custom failures using '{}' in '{}': {}", new Object[]{entry.getKey(), file.getName(), this.customFailureCount});
            }
        } else {
            if (this.countSuccesses) {
                this.successCount += XMLFileScanner.scanXmlFileForPattern(file, Pattern.compile(XML_REQUEST_SUCCESS_PATTERN, 2));
            }
            if (this.countFailures) {
                this.failureCount += XMLFileScanner.scanXmlFileForPattern(file, Pattern.compile(XML_REQUEST_FAILURE_PATTERN, 2));
            }
        }
    }

    @Override
    public int getFailureCount() {
        if (this.countFailures) {
            if (this.onlyFailWhenMatchingFailureMessage) {
                return this.customFailureCount;
            }
            return this.failureCount;
        }
        return 0;
    }

    @Override
    public int getSuccessCount() {
        if (this.countSuccesses) {
            return this.successCount;
        }
        return 0;
    }

    @Override
    public int getTotalCount() {
        return this.getSuccessCount() + this.getFailureCount();
    }
}

