/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.configuration;

import com.lazerycode.jmeter.configuration.JMeterCommandLineArguments;
import com.lazerycode.jmeter.configuration.LogLevel;
import com.lazerycode.jmeter.configuration.ProxyConfiguration;
import com.lazerycode.jmeter.utility.UtilityFunctions;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterArgumentsArray {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMeterArgumentsArray.class);
    private final String jMeterHome;
    private boolean disableTests;
    private final TreeSet<JMeterCommandLineArguments> argumentList = new TreeSet();
    private DateTimeFormatter dateFormat = DateTimeFormatter.BASIC_ISO_DATE;
    private ProxyConfiguration proxyConfiguration;
    private boolean timestampResults = false;
    private boolean appendTimestamp = false;
    private String resultFileExtension = ".jtl";
    private String remoteStartServerList;
    private List<String> customPropertiesFiles = new ArrayList<String>();
    private String testFile;
    private String resultsLogFileName;
    private String jmeterLogFileName;
    private String logsDirectory;
    private String resultsDirectory;
    private String reportDirectory;
    private LogLevel overrideRootLogLevel;
    private final List<String> extraOptions = new ArrayList<String>();

    public JMeterArgumentsArray(boolean disableGUI, String jMeterHomeDirectory) throws MojoExecutionException {
        if (UtilityFunctions.isNotSet(jMeterHomeDirectory).booleanValue()) {
            throw new MojoExecutionException("Unable to set JMeter Home Directory...");
        }
        this.jMeterHome = jMeterHomeDirectory;
        this.argumentList.add(JMeterCommandLineArguments.JMETER_HOME_OPT);
        if (disableGUI) {
            this.argumentList.add(JMeterCommandLineArguments.NONGUI_OPT);
            this.disableTests = false;
        } else {
            this.disableTests = true;
        }
    }

    public JMeterArgumentsArray setRemoteStop() {
        this.argumentList.add(JMeterCommandLineArguments.REMOTE_STOP);
        return this;
    }

    public JMeterArgumentsArray setRemoteStart() {
        this.argumentList.add(JMeterCommandLineArguments.REMOTE_OPT);
        return this;
    }

    public JMeterArgumentsArray setRemoteStartServerList(String serverList) {
        if (UtilityFunctions.isNotSet(serverList).booleanValue()) {
            return this;
        }
        this.remoteStartServerList = serverList;
        this.argumentList.add(JMeterCommandLineArguments.REMOTE_OPT_PARAM);
        return this;
    }

    public JMeterArgumentsArray setProxyConfig(ProxyConfiguration configuration) {
        if (configuration == null) {
            return this;
        }
        this.proxyConfiguration = configuration;
        if (UtilityFunctions.isSet(this.proxyConfiguration.getHost()).booleanValue()) {
            this.argumentList.add(JMeterCommandLineArguments.PROXY_HOST);
            this.argumentList.add(JMeterCommandLineArguments.PROXY_PORT);
        }
        if (UtilityFunctions.isSet(this.proxyConfiguration.getUsername()).booleanValue()) {
            this.argumentList.add(JMeterCommandLineArguments.PROXY_USERNAME);
        }
        if (UtilityFunctions.isSet(this.proxyConfiguration.getPassword()).booleanValue()) {
            this.argumentList.add(JMeterCommandLineArguments.PROXY_PASSWORD);
        }
        if (UtilityFunctions.isSet(this.proxyConfiguration.getHostExclusions()).booleanValue()) {
            this.argumentList.add(JMeterCommandLineArguments.NONPROXY_HOSTS);
        }
        return this;
    }

    public JMeterArgumentsArray addACustomPropertiesFiles(List<File> customPropertiesFiles) {
        if (UtilityFunctions.isNotSet(customPropertiesFiles).booleanValue()) {
            return this;
        }
        for (File customPropertiesFile : customPropertiesFiles) {
            this.customPropertiesFiles.add(customPropertiesFile.getAbsolutePath());
            this.argumentList.add(JMeterCommandLineArguments.PROPFILE2_OPT);
        }
        return this;
    }

    public JMeterArgumentsArray addExtraArgument(String argument) {
        this.extraOptions.add(argument);
        return this;
    }

    public JMeterArgumentsArray setLogRootOverride(String requestedLogLevel) {
        if (UtilityFunctions.isNotSet(requestedLogLevel).booleanValue()) {
            return this;
        }
        for (LogLevel logLevel : LogLevel.values()) {
            if (!logLevel.toString().equalsIgnoreCase(requestedLogLevel)) continue;
            this.overrideRootLogLevel = logLevel;
            this.argumentList.add(JMeterCommandLineArguments.LOGLEVEL);
            return this;
        }
        LOGGER.warn("Unknown log level {}", (Object)requestedLogLevel);
        return this;
    }

    public JMeterArgumentsArray setResultsDirectory(String resultsDirectory) {
        this.resultsDirectory = resultsDirectory;
        return this;
    }

    public JMeterArgumentsArray setLogsDirectory(String logsDirectory) {
        this.logsDirectory = logsDirectory;
        return this;
    }

    public JMeterArgumentsArray setResultsTimestamp(boolean addTimestamp) {
        this.timestampResults = addTimestamp;
        return this;
    }

    public JMeterArgumentsArray setResultsFileNameDateFormat(String dateFormat) {
        if (UtilityFunctions.isSet(dateFormat).booleanValue()) {
            try {
                this.dateFormat = DateTimeFormatter.ofPattern(dateFormat);
            }
            catch (Exception ex) {
                LOGGER.error("'" + dateFormat + "' is an invalid DateTimeFormat.  Defaulting to Standard ISO_8601.", (Throwable)ex);
            }
        }
        return this;
    }

    public JMeterArgumentsArray appendTimestamp(boolean append) {
        this.appendTimestamp = append;
        return this;
    }

    public JMeterArgumentsArray setResultFileOutputFormatIsCSV(boolean isCSVFormat) {
        this.resultFileExtension = isCSVFormat ? ".csv" : ".jtl";
        return this;
    }

    public JMeterArgumentsArray setTestFile(File value, File testFilesDirectory) {
        if (UtilityFunctions.isNotSet(value).booleanValue()) {
            return this;
        }
        this.testFile = value.getAbsolutePath();
        String resultFilename = FilenameUtils.removeExtension((String)testFilesDirectory.toURI().relativize(value.toURI()).getPath().replace("\\", "/").replace("/", "_"));
        this.resultsLogFileName = this.resultsDirectory + File.separator;
        this.resultsLogFileName = this.timestampResults ? (this.appendTimestamp ? this.resultsLogFileName + String.format("%s-%s%s", resultFilename, LocalDateTime.now().format(this.dateFormat), this.resultFileExtension) : this.resultsLogFileName + String.format("%s-%s%s", LocalDateTime.now().format(this.dateFormat), resultFilename, this.resultFileExtension)) : this.resultsLogFileName + resultFilename + this.resultFileExtension;
        if (UtilityFunctions.isSet(this.logsDirectory).booleanValue()) {
            this.jmeterLogFileName = this.logsDirectory + File.separator + value.getName() + ".log";
            this.argumentList.add(JMeterCommandLineArguments.JMLOGFILE_OPT);
        }
        this.argumentList.add(JMeterCommandLineArguments.TESTFILE_OPT);
        this.argumentList.add(JMeterCommandLineArguments.LOGFILE_OPT);
        this.disableTests = false;
        return this;
    }

    public JMeterArgumentsArray setReportsDirectory(String reportDirectory) {
        this.argumentList.add(JMeterCommandLineArguments.REPORT_AT_END_OPT);
        this.argumentList.add(JMeterCommandLineArguments.REPORT_OUTPUT_FOLDER_OPT);
        this.reportDirectory = reportDirectory;
        return this;
    }

    public JMeterArgumentsArray setServerMode(String exportedHostname, int port) {
        this.argumentList.add(JMeterCommandLineArguments.SERVER_OPT);
        this.disableTests = true;
        if (UtilityFunctions.isSet(this.logsDirectory).booleanValue()) {
            if (null == exportedHostname) {
                exportedHostname = "localhost";
            }
            this.jmeterLogFileName = this.logsDirectory + File.separator + String.format("%s_%s.log", exportedHostname, port);
            this.argumentList.add(JMeterCommandLineArguments.JMLOGFILE_OPT);
        }
        return this;
    }

    public String getResultsLogFileName() {
        return this.resultsLogFileName;
    }

    public List<String> buildArgumentsArray() throws MojoExecutionException {
        if (!this.argumentList.contains((Object)JMeterCommandLineArguments.TESTFILE_OPT) && !this.disableTests) {
            throw new MojoExecutionException("No test(s) specified!");
        }
        ArrayList<String> argumentsArray = new ArrayList<String>();
        block20: for (JMeterCommandLineArguments argument : this.argumentList) {
            switch (argument) {
                case NONGUI_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.NONGUI_OPT.getCommandLineArgument());
                    break;
                }
                case TESTFILE_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.TESTFILE_OPT.getCommandLineArgument());
                    argumentsArray.add(this.testFile);
                    break;
                }
                case LOGFILE_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.LOGFILE_OPT.getCommandLineArgument());
                    argumentsArray.add(this.resultsLogFileName);
                    break;
                }
                case JMETER_HOME_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.JMETER_HOME_OPT.getCommandLineArgument());
                    argumentsArray.add(this.jMeterHome);
                    break;
                }
                case LOGLEVEL: {
                    argumentsArray.add(JMeterCommandLineArguments.LOGLEVEL.getCommandLineArgument());
                    argumentsArray.add(this.overrideRootLogLevel.toString());
                    break;
                }
                case PROPFILE2_OPT: {
                    for (String customPropertiesFile : this.customPropertiesFiles) {
                        argumentsArray.add(JMeterCommandLineArguments.PROPFILE2_OPT.getCommandLineArgument());
                        argumentsArray.add(customPropertiesFile);
                    }
                    continue block20;
                }
                case REMOTE_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.REMOTE_OPT.getCommandLineArgument());
                    break;
                }
                case PROXY_HOST: {
                    argumentsArray.add(JMeterCommandLineArguments.PROXY_HOST.getCommandLineArgument());
                    argumentsArray.add(this.proxyConfiguration.getHost());
                    break;
                }
                case PROXY_PORT: {
                    argumentsArray.add(JMeterCommandLineArguments.PROXY_PORT.getCommandLineArgument());
                    argumentsArray.add(this.proxyConfiguration.getPort());
                    break;
                }
                case PROXY_USERNAME: {
                    argumentsArray.add(JMeterCommandLineArguments.PROXY_USERNAME.getCommandLineArgument());
                    argumentsArray.add(this.proxyConfiguration.getUsername());
                    break;
                }
                case PROXY_PASSWORD: {
                    argumentsArray.add(JMeterCommandLineArguments.PROXY_PASSWORD.getCommandLineArgument());
                    argumentsArray.add(this.proxyConfiguration.getPassword());
                    break;
                }
                case NONPROXY_HOSTS: {
                    argumentsArray.add(JMeterCommandLineArguments.NONPROXY_HOSTS.getCommandLineArgument());
                    argumentsArray.add(this.proxyConfiguration.getHostExclusions());
                    break;
                }
                case REMOTE_STOP: {
                    argumentsArray.add(JMeterCommandLineArguments.REMOTE_STOP.getCommandLineArgument());
                    break;
                }
                case REMOTE_OPT_PARAM: {
                    argumentsArray.add(JMeterCommandLineArguments.REMOTE_OPT_PARAM.getCommandLineArgument());
                    argumentsArray.add(this.remoteStartServerList);
                    break;
                }
                case JMLOGFILE_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.JMLOGFILE_OPT.getCommandLineArgument());
                    argumentsArray.add(this.jmeterLogFileName);
                    break;
                }
                case REPORT_AT_END_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.REPORT_AT_END_OPT.getCommandLineArgument());
                    break;
                }
                case REPORT_OUTPUT_FOLDER_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.REPORT_OUTPUT_FOLDER_OPT.getCommandLineArgument());
                    argumentsArray.add(this.reportDirectory);
                    break;
                }
                case SERVER_OPT: {
                    argumentsArray.add(JMeterCommandLineArguments.SERVER_OPT.getCommandLineArgument());
                    break;
                }
            }
        }
        argumentsArray.addAll(this.extraOptions);
        return argumentsArray;
    }
}

