/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;

public class ArtifactHelpers {
    private static final List<String> LIBRARY_ARTIFACT_EXTENSIONS = Arrays.asList("jar", "war", "zip", "ear");
    private static final Pattern COORDINATE_PATTERN = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]+))?(:([^: ]+))?");
    private static final String ARTIFACT_STAR = "*";
    static final String JMETER_GROUP_ID = "org.apache.jmeter";
    static final List<String> JMETER_ARTIFACT_NAMES = Arrays.asList("ApacheJMeter", "ApacheJMeter_bolt", "ApacheJMeter_components", "ApacheJMeter_config", "ApacheJMeter_core", "ApacheJMeter_ftp", "ApacheJMeter_functions", "ApacheJMeter_http", "ApacheJMeter_java", "ApacheJMeter_jdbc", "ApacheJMeter_jms", "ApacheJMeter_junit", "ApacheJMeter_ldap", "ApacheJMeter_mail", "ApacheJMeter_mongodb", "ApacheJMeter_native", "ApacheJMeter_tcp", "jorphan");
    static final List<String> BLOCKED_ARTIFACTS = Arrays.asList("d-haven-managed-pool:d-haven-managed-pool", "event:event", "commons-pool2:commons-pool2", "commons-math3:commons-math3", "logkit:logkit", "avalon-logkit:avalon-logkit");

    ArtifactHelpers() throws InstantiationError {
        throw new InstantiationError("This class is non-instantiable.");
    }

    public static Set<Exclusion> setupExcludedArtifacts(List<String> excludedArtifacts) throws MojoExecutionException {
        HashSet<Exclusion> exclusionSet = new HashSet<Exclusion>();
        for (String artifact : Optional.ofNullable(excludedArtifacts).orElse(Collections.emptyList())) {
            exclusionSet.add(ArtifactHelpers.convertExclusionPatternIntoExclusion(artifact));
        }
        for (String artifact : BLOCKED_ARTIFACTS) {
            exclusionSet.add(ArtifactHelpers.convertExclusionPatternIntoExclusion(artifact));
        }
        return exclusionSet;
    }

    static Exclusion convertExclusionPatternIntoExclusion(String exceptionPattern) throws MojoExecutionException {
        Matcher matcher = COORDINATE_PATTERN.matcher(exceptionPattern);
        if (!matcher.matches()) {
            throw new MojoExecutionException(String.format("Bad artifact coordinates %s, expected format is <groupId>:<artifactId>[:<extension>][:<classifier>]", exceptionPattern));
        }
        return new Exclusion(matcher.group(1), matcher.group(2), matcher.group(4), matcher.group(6));
    }

    public static boolean containsExclusion(Collection<Exclusion> exclusions, Exclusion exclusion) {
        return ((Collection)Optional.ofNullable(exclusions).orElse(Collections.emptyList())).stream().anyMatch(selectedExclusion -> null != exclusion && selectedExclusion.getGroupId().equals(exclusion.getGroupId()) && (selectedExclusion.getArtifactId().equals(exclusion.getArtifactId()) || selectedExclusion.getArtifactId().equals(ARTIFACT_STAR)));
    }

    public static boolean artifactIsNotExcluded(Collection<Exclusion> exclusions, Artifact artifact) {
        return ((Collection)Optional.ofNullable(exclusions).orElse(Collections.emptyList())).stream().noneMatch(selectedExclusion -> null != artifact && selectedExclusion.getGroupId().equals(artifact.getGroupId()) && (selectedExclusion.getArtifactId().equals(artifact.getArtifactId()) || selectedExclusion.getArtifactId().equals(ARTIFACT_STAR)));
    }

    public static List<String> createDefaultJmeterArtifactsArray(String jmeterVersion) {
        ArrayList<String> artifacts = new ArrayList<String>();
        JMETER_ARTIFACT_NAMES.forEach(artifactName -> artifacts.add(String.format("%s:%s:%s", JMETER_GROUP_ID, artifactName, jmeterVersion)));
        return artifacts;
    }

    public static boolean isArtifactALibrary(Artifact artifact) {
        return LIBRARY_ARTIFACT_EXTENSIONS.contains(artifact.getExtension());
    }

    public static boolean isArtifactIsOlderThanArtifact(Artifact artifact, Artifact comparisonArtifact) throws InvalidVersionSpecificationException {
        Version secondArtifactVersion;
        GenericVersionScheme genericVersionScheme = new GenericVersionScheme();
        Version firstArtifactVersion = genericVersionScheme.parseVersion(artifact.getVersion());
        return firstArtifactVersion.compareTo((Object)(secondArtifactVersion = genericVersionScheme.parseVersion(comparisonArtifact.getVersion()))) < 0;
    }

    public static boolean artifactsAreMatchingTypes(Artifact first, Artifact second) {
        return first.getGroupId().equals(second.getGroupId()) && first.getArtifactId().equals(second.getArtifactId()) && first.getExtension().equals(second.getExtension()) && first.getClassifier().equals(second.getClassifier());
    }

    public static Artifact resolveArtifactVersion(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> repositoryList, Artifact desiredArtifact) throws VersionRangeResolutionException {
        Pattern isAVersionRange = Pattern.compile("[\\[|\\(].+[\\]|\\)]");
        if (isAVersionRange.matcher(desiredArtifact.getVersion()).matches()) {
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(desiredArtifact, repositoryList, null);
            VersionRangeResult versionRangeResult = repositorySystem.resolveVersionRange(repositorySystemSession, versionRangeRequest);
            return desiredArtifact.setVersion(versionRangeResult.getHighestVersion().toString());
        }
        return desiredArtifact;
    }
}

