/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.results;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.lazerycode.jmeter.results.CSVScanResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;

public class CSVFileScanner {
    private static final String ROW_NAME_SUCCESS = "success";
    private static final String ROW_NAME_FAILURE_MESSAGE = "failureMessage";
    private static final CsvMapper CSV_MAPPER = new CsvMapper();
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    protected static CSVScanResult scanCsvForValues(File file, List<String> values) throws MojoExecutionException {
        Map<String, Integer> specificFailureMessages = values.stream().collect(Collectors.toMap(Function.identity(), a -> 0));
        int successCount = 0;
        int failureCount = 0;
        try {
            char separator = CSVFileScanner.computeSeparator(file);
            CsvSchema schema = CsvSchema.emptySchema().withHeader().withColumnSeparator(separator);
            try (FileReader fr = new FileReader(file);
                 BufferedReader reader = new BufferedReader(fr, 8192);){
                MappingIterator it = CSV_MAPPER.readerFor(Map.class).with((FormatSchema)schema).readValues((Reader)reader);
                while (it.hasNext()) {
                    Map row = (Map)it.next();
                    if (Boolean.parseBoolean((String)row.get(ROW_NAME_SUCCESS))) {
                        ++successCount;
                        continue;
                    }
                    ++failureCount;
                    for (Map.Entry<String, Integer> entry : specificFailureMessages.entrySet()) {
                        String failureMessage = (String)row.get(ROW_NAME_FAILURE_MESSAGE);
                        if (!entry.getKey().equalsIgnoreCase(failureMessage)) continue;
                        entry.setValue(entry.getValue() + 1);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("An unexpected error occurred while reading file " + file.getAbsolutePath(), (Exception)e);
        }
        return new CSVScanResult(specificFailureMessages, successCount, failureCount);
    }

    private static char computeSeparator(File file) throws IOException {
        Throwable throwable = null;
        try (FileReader fr = new FileReader(file);){
            Throwable throwable2;
            BufferedReader reader;
            block25: {
                char c;
                block26: {
                    block27: {
                        reader = new BufferedReader(fr, 8192);
                        throwable2 = null;
                        String line = reader.readLine();
                        if (line == null) break block25;
                        c = CSVFileScanner.lookForDelimiter(line);
                        if (reader == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    reader.close();
                }
                return c;
            }
            try {
                try {
                    try {
                        throw new IllegalArgumentException("No line read from file " + file.getAbsolutePath());
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (reader != null) {
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            reader.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    private static char lookForDelimiter(String line) {
        for (char ch : line.toCharArray()) {
            if (Character.isLetter(ch)) continue;
            return ch;
        }
        throw new IllegalStateException("Cannot find delimiter in header " + line);
    }
}

