/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.configuration.ArtifactHelpers;
import com.lazerycode.jmeter.configuration.RepositoryConfiguration;
import com.lazerycode.jmeter.json.TestConfigurationWrapper;
import com.lazerycode.jmeter.mojo.AbstractJMeterMojo;
import com.lazerycode.jmeter.properties.ConfigurationFiles;
import com.lazerycode.jmeter.properties.PropertiesFile;
import com.lazerycode.jmeter.properties.PropertiesMapping;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.version.InvalidVersionSpecificationException;

@Mojo(name="configure", defaultPhase=LifecyclePhase.COMPILE)
public class ConfigureJMeterMojo
extends AbstractJMeterMojo {
    private static final String DEPENDENCIES_DEFAULT_SEARCH_SCOPE = "runtime";
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> repositoryList;
    @Parameter
    protected List<RepositoryConfiguration> additionalRepositories = new ArrayList<RepositoryConfiguration>();
    private static final String BASE_CONFIG_FILE = "/config.json";
    @Parameter(property="jmeter.version", defaultValue="5.4.2")
    private String jmeterVersion;
    @Parameter
    private List<String> jmeterArtifacts = new ArrayList<String>();
    @Parameter
    private List<String> excludedArtifacts = new ArrayList<String>();
    @Parameter
    private List<String> ignoredArtifacts = new ArrayList<String>();
    @Parameter(defaultValue="true")
    protected boolean downloadExtensionDependencies;
    @Parameter
    protected List<String> jmeterExtensions = new ArrayList<String>();
    @Parameter(defaultValue="true")
    protected boolean downloadJMeterDependencies;
    @Parameter(defaultValue="false")
    protected boolean downloadOptionalDependencies;
    @Parameter(defaultValue="true")
    protected boolean downloadLibraryDependencies;
    @Parameter
    protected List<String> junitLibraries = new ArrayList<String>();
    @Parameter
    protected List<String> testPlanLibraries = new ArrayList<String>();
    @Parameter
    protected Map<String, String> propertiesJMeter = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesSaveService = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesReportGenerator = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesUpgrade = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesUser = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesGlobal = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> propertiesSystem = new HashMap<String, String>();
    @Parameter(defaultValue="${basedir}/src/test/jmeter")
    protected File propertiesFilesDirectory;
    @Parameter(defaultValue="true")
    protected boolean propertiesReplacedByCustomFiles;
    private Set<Exclusion> parsedExcludedArtifacts = new HashSet<Exclusion>();
    private Set<Exclusion> processedArtifacts = new HashSet<Exclusion>();
    private Set<Artifact> copiedArtifacts = new HashSet<Artifact>();
    @Parameter(defaultValue="csv")
    protected String resultsFileFormat;
    protected boolean resultsOutputIsCSVFormat = true;
    protected Artifact jmeterConfigArtifact;
    protected Path customPropertiesDirectory;
    protected Path jmeterDirectoryPath;
    protected Path binDirectory;
    protected Path libDirectory;
    protected Path libExtDirectory;
    protected Path libJUnitDirectory;

    @Override
    public void doExecute() throws MojoExecutionException {
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)"C O N F I G U R I N G    J M E T E R");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)("Creating test configuration for execution ID: " + this.mojoExecution.getExecutionId()));
        this.testConfig = new TestConfigurationWrapper();
        this.testConfig.getCurrentTestConfiguration().setExecutionID(this.mojoExecution.getExecutionId());
        this.testConfig.getCurrentTestConfiguration().setGenerateReports(this.generateReports);
        this.processedArtifacts.clear();
        this.parsedExcludedArtifacts = ArtifactHelpers.setupExcludedArtifacts(this.excludedArtifacts);
        this.getLog().info((CharSequence)"Building JMeter directory structure...");
        this.getLog().info((CharSequence)"Generating JSON Test config...");
        this.jmeterDirectoryPath = Paths.get(this.projectBuildDirectory.getAbsolutePath(), UUID.randomUUID().toString(), "jmeter");
        this.testConfig.getCurrentTestConfiguration().setJmeterDirectoryPath(this.jmeterDirectoryPath.toString());
        this.generateJMeterDirectoryTree();
        this.getLog().info((CharSequence)"Configuring JMeter artifacts...");
        this.configureJMeterArtifacts();
        this.getLog().info((CharSequence)"Populating JMeter directory...");
        this.populateJMeterDirectoryTree();
        this.copyExplicitLibraries(this.jmeterExtensions, this.libExtDirectory.toFile(), this.downloadExtensionDependencies, "extensions");
        this.copyExplicitLibraries(this.junitLibraries, this.libJUnitDirectory.toFile(), this.downloadLibraryDependencies, "junit libraries");
        this.copyExplicitLibraries(this.testPlanLibraries, this.libDirectory.toFile(), this.downloadLibraryDependencies, "test plan libraries");
        this.getLog().info((CharSequence)"Configuring JMeter properties...");
        this.configurePropertiesFiles();
        this.testConfig.writeResultFilesConfigTo(this.testConfigFile);
    }

    private void generateJMeterDirectoryTree() throws MojoExecutionException {
        this.binDirectory = this.jmeterDirectoryPath.resolve("bin");
        this.customPropertiesDirectory = this.jmeterDirectoryPath.resolve("custom_properties");
        this.libDirectory = this.jmeterDirectoryPath.resolve("lib");
        this.libExtDirectory = this.libDirectory.resolve("ext");
        this.libJUnitDirectory = this.libDirectory.resolve("junit");
        try {
            Files.createDirectories(this.jmeterDirectoryPath, new FileAttribute[0]);
            Files.createDirectories(this.binDirectory, new FileAttribute[0]);
            Files.createDirectories(this.customPropertiesDirectory, new FileAttribute[0]);
            Files.createDirectories(this.libExtDirectory, new FileAttribute[0]);
            Files.createDirectories(this.libJUnitDirectory, new FileAttribute[0]);
            this.testFilesBuildDirectory.mkdirs();
            this.resultsDirectory.mkdirs();
            if (this.generateReports) {
                this.reportDirectory.mkdirs();
            }
            this.logsDirectory.mkdirs();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void configurePropertiesFiles() throws MojoExecutionException {
        EnumMap<ConfigurationFiles, PropertiesMapping> propertiesMap = new EnumMap<ConfigurationFiles, PropertiesMapping>(ConfigurationFiles.class);
        propertiesMap.put(ConfigurationFiles.JMETER_PROPERTIES, new PropertiesMapping(this.propertiesJMeter));
        propertiesMap.put(ConfigurationFiles.SAVE_SERVICE_PROPERTIES, new PropertiesMapping(this.propertiesSaveService));
        propertiesMap.put(ConfigurationFiles.UPGRADE_PROPERTIES, new PropertiesMapping(this.propertiesUpgrade));
        propertiesMap.put(ConfigurationFiles.SYSTEM_PROPERTIES, new PropertiesMapping(this.propertiesSystem));
        propertiesMap.put(ConfigurationFiles.REPORT_GENERATOR_PROPERTIES, new PropertiesMapping(this.propertiesReportGenerator));
        propertiesMap.put(ConfigurationFiles.USER_PROPERTIES, new PropertiesMapping(this.propertiesUser));
        propertiesMap.put(ConfigurationFiles.GLOBAL_PROPERTIES, new PropertiesMapping(this.propertiesGlobal));
        this.setJMeterResultFileFormat();
        for (ConfigurationFiles configurationFile : ConfigurationFiles.values()) {
            File suppliedPropertiesFile = new File(this.propertiesFilesDirectory, configurationFile.getFilename());
            File propertiesFileToWrite = new File(this.testConfig.getCurrentTestConfiguration().getJmeterWorkingDirectoryPath(), configurationFile.getFilename());
            PropertiesFile somePropertiesFile = new PropertiesFile(this.jmeterConfigArtifact, configurationFile);
            somePropertiesFile.loadProvidedPropertiesIfAvailable(suppliedPropertiesFile, this.propertiesReplacedByCustomFiles);
            somePropertiesFile.addAndOverwriteProperties(((PropertiesMapping)propertiesMap.get((Object)configurationFile)).getAdditionalProperties());
            somePropertiesFile.writePropertiesToFile(propertiesFileToWrite);
            ((PropertiesMapping)propertiesMap.get((Object)configurationFile)).setPropertiesFile(somePropertiesFile);
        }
        for (File customPropertiesFile : this.customPropertiesFiles) {
            PropertiesFile customProperties = new PropertiesFile(customPropertiesFile);
            String customPropertiesFilename = FilenameUtils.getBaseName((String)customPropertiesFile.getName()) + "-" + UUID.randomUUID() + "." + FilenameUtils.getExtension((String)customPropertiesFile.getName());
            customProperties.writePropertiesToFile(this.customPropertiesDirectory.resolve(customPropertiesFilename).toFile());
        }
        this.testConfig.getCurrentTestConfiguration().setPropertiesMap(propertiesMap);
        this.setDefaultPluginProperties(this.testConfig.getCurrentTestConfiguration().getJmeterWorkingDirectoryPath().getAbsolutePath());
    }

    protected void setJMeterResultFileFormat() {
        if (this.generateReports || "csv".equalsIgnoreCase(this.resultsFileFormat)) {
            this.propertiesJMeter.put("jmeter.save.saveservice.output_format", "csv");
            this.resultsOutputIsCSVFormat = true;
        } else {
            this.propertiesJMeter.put("jmeter.save.saveservice.output_format", "xml");
            this.resultsOutputIsCSVFormat = false;
        }
        this.testConfig.getCurrentTestConfiguration().setResultsOutputIsCSVFormat(this.resultsOutputIsCSVFormat);
    }

    public void setDefaultPluginProperties(String userDirectory) {
        System.setProperty("user.dir", userDirectory);
        System.setProperty("jmeterengine.remote.system.exit", "false");
        System.setProperty("jmeterengine.stopfail.system.exit", "false");
    }

    private void configureJMeterArtifacts() {
        if (this.jmeterArtifacts.isEmpty()) {
            this.jmeterArtifacts = ArtifactHelpers.createDefaultJmeterArtifactsArray(this.jmeterVersion);
        }
        this.getLog().debug((CharSequence)"JMeter Artifact List:");
        this.jmeterArtifacts.forEach(artifact -> this.getLog().debug((CharSequence)artifact));
    }

    private void populateJMeterDirectoryTree() throws MojoExecutionException {
        if (this.jmeterArtifacts.isEmpty()) {
            throw new MojoExecutionException("No JMeter dependencies specified!, check jmeterArtifacts and jmeterVersion elements");
        }
        block10: for (String desiredArtifact : this.jmeterArtifacts) {
            Artifact returnedArtifact = this.getArtifactResult((Artifact)new DefaultArtifact(desiredArtifact));
            switch (returnedArtifact.getArtifactId()) {
                case "ApacheJMeter_config": {
                    this.jmeterConfigArtifact = returnedArtifact;
                    this.extractConfigSettings(this.jmeterConfigArtifact);
                    continue block10;
                }
                case "ApacheJMeter": {
                    this.testConfig.getCurrentTestConfiguration().setRuntimeJarName(returnedArtifact.getFile().getName());
                    this.copyArtifactIfRequired(returnedArtifact, this.binDirectory);
                    this.copyTransitiveRuntimeDependenciesToLibDirectory(returnedArtifact, this.downloadJMeterDependencies);
                    continue block10;
                }
                case "jorphan": {
                    this.copyArtifactIfRequired(returnedArtifact, this.libDirectory);
                    this.copyTransitiveRuntimeDependenciesToLibDirectory(returnedArtifact, this.downloadJMeterDependencies);
                    continue block10;
                }
            }
            this.copyArtifactIfRequired(returnedArtifact, this.libExtDirectory);
            this.copyTransitiveRuntimeDependenciesToLibDirectory(returnedArtifact, this.downloadJMeterDependencies);
        }
        if (this.confFilesDirectory.exists()) {
            ConfigureJMeterMojo.copyFilesInTestDirectory(this.confFilesDirectory, this.binDirectory.toFile());
        }
    }

    private void copyExplicitLibraries(List<String> desiredArtifacts, File destination, boolean downloadDependencies, String description) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Copying %s to %s \nDownloading dependencies: %s", description, destination, downloadDependencies));
        for (String desiredArtifact : desiredArtifacts) {
            this.copyExplicitLibrary(desiredArtifact, destination, downloadDependencies);
        }
    }

    private void copyExplicitLibrary(String desiredArtifact, File destination, boolean downloadDependencies) throws MojoExecutionException {
        this.getLog().debug((CharSequence)String.format("Copying %s to %s", desiredArtifact, destination.getAbsolutePath()));
        Artifact returnedArtifact = this.getArtifactResult((Artifact)new DefaultArtifact(desiredArtifact));
        this.copyArtifactIfRequired(returnedArtifact, Paths.get(destination.toURI()));
        if (downloadDependencies) {
            this.resolveTestDependenciesAndCopyWithTransitivity(returnedArtifact);
        }
    }

    private Artifact getArtifactResult(Artifact desiredArtifact) throws MojoExecutionException {
        try {
            ArtifactRequest artifactRequest = new ArtifactRequest().setArtifact(ArtifactHelpers.resolveArtifactVersion(this.repositorySystem, this.repositorySystemSession, this.repositoryList, desiredArtifact));
            this.additionalRepositories.forEach(additionalRepository -> this.repositoryList.add(additionalRepository.getRemoteRepository()));
            artifactRequest.setRepositories(this.repositoryList);
            return this.repositorySystem.resolveArtifact(this.repositorySystemSession, artifactRequest).getArtifact();
        }
        catch (ArtifactResolutionException | VersionRangeResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void resolveTestDependenciesAndCopyWithTransitivity(Artifact artifact) throws MojoExecutionException {
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(artifact, this.repositoryList, null);
        try {
            ArtifactDescriptorResult result = this.repositorySystem.readArtifactDescriptor(this.repositorySystemSession, request);
            for (Dependency dep : result.getDependencies()) {
                ArtifactRequest artifactRequest = new ArtifactRequest(ArtifactHelpers.resolveArtifactVersion(this.repositorySystem, this.repositorySystemSession, this.repositoryList, dep.getArtifact()), this.repositoryList, null);
                ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(this.repositorySystemSession, artifactRequest);
                if (ArtifactHelpers.isArtifactALibrary(artifactResult.getArtifact())) {
                    this.copyArtifactIfRequired(artifactResult.getArtifact(), this.libDirectory);
                } else {
                    this.getLog().debug((CharSequence)("Artifact " + artifactResult.getArtifact() + " is not a library, ignoring"));
                }
                this.copyTransitiveRuntimeDependenciesToLibDirectory(dep, true);
            }
        }
        catch (ArtifactDescriptorException | ArtifactResolutionException | VersionRangeResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void copyTransitiveRuntimeDependenciesToLibDirectory(Artifact artifact, boolean getDependenciesOfDependency) throws MojoExecutionException {
        this.copyTransitiveRuntimeDependenciesToLibDirectory(new Dependency(artifact, DEPENDENCIES_DEFAULT_SEARCH_SCOPE), getDependenciesOfDependency);
    }

    private void copyTransitiveRuntimeDependenciesToLibDirectory(Dependency rootDependency, boolean getDependenciesOfDependency) throws MojoExecutionException {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(rootDependency);
        collectRequest.setRepositories(this.repositoryList);
        DependencyFilter dependencyFilter = DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{DependencyFilterUtils.classpathFilter((String[])new String[]{DEPENDENCIES_DEFAULT_SEARCH_SCOPE}), (dependencyNode, arg1) -> {
            Artifact artifact = dependencyNode.getArtifact();
            if (dependencyNode.getDependency().isOptional()) {
                this.getLog().debug((CharSequence)("Filtering dependency " + dependencyNode.getDependency()));
                return false;
            }
            boolean notExcluded = ArtifactHelpers.artifactIsNotExcluded(this.parsedExcludedArtifacts, artifact);
            if (!notExcluded) {
                this.getLog().debug((CharSequence)("Filtering excluded dependency " + dependencyNode.getDependency()));
            }
            return notExcluded;
        }});
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, dependencyFilter);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Root dependency name: " + rootDependency.toString()));
            if (dependencyRequest.getCollectRequest() != null && dependencyRequest.getCollectRequest().getTrace() != null) {
                this.getLog().debug((CharSequence)("Root dependency request trace: " + dependencyRequest.getCollectRequest().getTrace().toString()));
            }
            this.getLog().debug((CharSequence)("Root dependency exclusions: " + rootDependency.getExclusions()));
            this.getLog().debug((CharSequence)"-------------------------------------------------------");
        }
        try {
            List artifactDependencyNodes = this.repositorySystem.collectDependencies(this.repositorySystemSession, collectRequest).getRoot().getChildren();
            for (DependencyNode dependencyNode2 : artifactDependencyNodes) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Dependency name: " + dependencyNode2.toString()));
                    if (dependencyRequest.getCollectRequest() != null && dependencyRequest.getCollectRequest().getTrace() != null) {
                        this.getLog().debug((CharSequence)("Dependency request trace: " + dependencyRequest.getCollectRequest().getTrace().toString()));
                    }
                }
                Exclusion dummyExclusion = new Exclusion(dependencyNode2.getArtifact().getGroupId(), dependencyNode2.getArtifact().getArtifactId(), dependencyNode2.getArtifact().getClassifier(), dependencyNode2.getArtifact().getExtension());
                if (!this.downloadOptionalDependencies && dependencyNode2.getDependency().isOptional() || ArtifactHelpers.containsExclusion(this.parsedExcludedArtifacts, dummyExclusion) || rootDependency.getExclusions() != null && ArtifactHelpers.containsExclusion(rootDependency.getExclusions(), dummyExclusion)) continue;
                ArtifactRequest artifactRequest = new ArtifactRequest(dependencyNode2);
                artifactRequest.setArtifact(ArtifactHelpers.resolveArtifactVersion(this.repositorySystem, this.repositorySystemSession, this.repositoryList, artifactRequest.getArtifact()));
                Artifact returnedArtifact = this.repositorySystem.resolveArtifact(this.repositorySystemSession, artifactRequest).getArtifact();
                if (!returnedArtifact.getArtifactId().startsWith("ApacheJMeter_") && ArtifactHelpers.isArtifactALibrary(returnedArtifact)) {
                    this.copyArtifactIfRequired(returnedArtifact, this.libDirectory);
                }
                if (!getDependenciesOfDependency || this.processedArtifacts.contains(dummyExclusion)) continue;
                this.processedArtifacts.add(dummyExclusion);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Added to processed list: " + dummyExclusion));
                    this.getLog().debug((CharSequence)("total processed: " + this.processedArtifacts.size()));
                    this.getLog().debug((CharSequence)"-------------------------------------------------------");
                }
                this.copyTransitiveRuntimeDependenciesToLibDirectory(dependencyNode2.getDependency(), true);
            }
        }
        catch (DependencyCollectionException | ArtifactResolutionException | VersionRangeResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private boolean copyArtifactIfRequired(Artifact artifactToCopy, Path destinationDirectory) throws MojoExecutionException {
        for (String ignoredArtifact : this.ignoredArtifacts) {
            Artifact artifactToIgnore = this.getArtifactResult((Artifact)new DefaultArtifact(ignoredArtifact));
            if (!artifactToCopy.getFile().getName().equals(artifactToIgnore.getFile().getName())) continue;
            this.getLog().debug((CharSequence)(artifactToCopy.getFile().getName() + " has not been copied over because it is in the ignore list."));
            return false;
        }
        try {
            Path desiredArtifact;
            Iterator<Artifact> iterator = this.copiedArtifacts.iterator();
            while (iterator.hasNext()) {
                Artifact alreadyCopiedArtifact = iterator.next();
                if (!ArtifactHelpers.artifactsAreMatchingTypes(alreadyCopiedArtifact, artifactToCopy)) continue;
                if (ArtifactHelpers.isArtifactIsOlderThanArtifact(alreadyCopiedArtifact, artifactToCopy)) {
                    Path artifactToDelete = Paths.get(destinationDirectory.toString(), alreadyCopiedArtifact.getFile().getName());
                    this.getLog().debug((CharSequence)String.format("Deleting file:'%s'", artifactToDelete));
                    Files.deleteIfExists(artifactToDelete);
                    iterator.remove();
                    break;
                }
                return false;
            }
            if (!(desiredArtifact = Paths.get(destinationDirectory.toString(), artifactToCopy.getFile().getName())).toFile().exists()) {
                this.getLog().debug((CharSequence)String.format("Copying: %s to %s", desiredArtifact, destinationDirectory.toString()));
                Files.copy(Paths.get(artifactToCopy.getFile().getAbsolutePath(), new String[0]), desiredArtifact, new CopyOption[0]);
            }
        }
        catch (IOException | InvalidVersionSpecificationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.copiedArtifacts.add(artifactToCopy);
        return true;
    }

    private void extractConfigSettings(Artifact artifact) throws MojoExecutionException {
        try (JarFile configSettings = new JarFile(artifact.getFile());){
            Enumeration<JarEntry> entries = configSettings.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarFileEntry = entries.nextElement();
                if (jarFileEntry.isDirectory() || !jarFileEntry.getName().startsWith("bin") || jarFileEntry.getName().endsWith(".properties")) continue;
                Files.createDirectories(this.jmeterDirectoryPath.resolve(new File(jarFileEntry.getName()).getParentFile().getPath()), new FileAttribute[0]);
                Files.copy(configSettings.getInputStream(jarFileEntry), this.jmeterDirectoryPath.resolve(jarFileEntry.getName()), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

