/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.configuration.JMeterProcessJVMSettings;
import com.lazerycode.jmeter.configuration.ProxyConfiguration;
import com.lazerycode.jmeter.configuration.RemoteConfiguration;
import com.lazerycode.jmeter.json.TestConfigurationWrapper;
import io.perfana.eventscheduler.api.config.EventSchedulerConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;

public abstract class AbstractJMeterMojo
extends AbstractMojo {
    public static final String DEFAULT_CONFIG_EXECUTION_ID = "configuration";
    protected static final String LINE_SEPARATOR = "-------------------------------------------------------";
    protected static final String JMETER_ARTIFACT_PREFIX = "ApacheJMeter_";
    protected static final String JMETER_ARTIFACT_NAME = "ApacheJMeter";
    protected static final String JMETER_CONFIG_ARTIFACT_NAME = "ApacheJMeter_config";
    protected static final String JORPHAN_ARTIFACT_NAME = "jorphan";
    @Parameter
    protected List<String> testFilesIncluded = new ArrayList<String>();
    @Parameter
    protected List<String> testFilesExcluded = new ArrayList<String>();
    @Parameter(defaultValue="${basedir}/src/test/conf")
    protected File confFilesDirectory;
    @Parameter(defaultValue="${basedir}/src/test/jmeter")
    protected File testFilesDirectory;
    @Parameter(defaultValue="true")
    protected boolean testResultsTimestamp;
    @Parameter(defaultValue="false")
    protected boolean appendResultsTimestamp;
    @Parameter
    protected String resultsFileNameDateFormat;
    @Parameter(defaultValue="false")
    protected boolean generateReports;
    @Parameter(defaultValue="false")
    protected boolean doNotFailBuildIfJVMIsKilled;
    @Parameter(defaultValue="${project.build.directory}/jmeter/results")
    protected File resultsDirectory;
    @Parameter(defaultValue="${project.build.directory}/jmeter/reports")
    protected File reportDirectory;
    @Parameter(defaultValue="${project.build.directory}/jmeter/logs")
    protected File logsDirectory;
    @Parameter(defaultValue="${project.build.directory}/jmeter/testFiles")
    protected File testFilesBuildDirectory;
    @Parameter
    protected List<File> customPropertiesFiles = new ArrayList<File>();
    @Parameter
    protected boolean useMavenProxy;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter
    protected ProxyConfiguration proxyConfig;
    @Parameter(defaultValue="${remoteConfig}")
    protected RemoteConfiguration remoteConfig;
    @Parameter(defaultValue="${jMeterProcessJVMSettings}")
    protected JMeterProcessJVMSettings jMeterProcessJVMSettings;
    @Parameter
    protected String overrideRootLogLevel;
    @Parameter(defaultValue="false")
    protected boolean suppressJMeterOutput;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    protected MojoExecution mojoExecution;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${skipTests}")
    protected boolean skipTests;
    @Parameter(defaultValue="0")
    protected String postTestPauseInSeconds;
    @Parameter(defaultValue="${project.build.directory}/config.json")
    protected String testConfigFile;
    @Parameter(property="selectConfiguration", defaultValue="configuration")
    protected String selectedConfiguration;
    @Parameter(required=true)
    EventSchedulerConfig eventSchedulerConfig;
    @Parameter(defaultValue="${project.build.directory}")
    protected File projectBuildDirectory;
    protected TestConfigurationWrapper testConfig;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests) {
            if (this.session.getGoals().contains("jmeter:gui") || this.session.getGoals().contains("jmeter:remote-server")) {
                if (!"default-cli".equals(this.mojoExecution.getExecutionId()) && !"compile".equals(this.mojoExecution.getLifecyclePhase())) {
                    this.getLog().info((CharSequence)"Performance tests are skipped.");
                    return;
                }
            } else {
                this.getLog().info((CharSequence)"Performance tests are skipped.");
                return;
            }
        }
        if (this.useMavenProxy && this.proxyConfig == null) {
            this.loadMavenProxy();
        }
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected JMeterArgumentsArray computeJMeterArgumentsArray(boolean disableGUI, boolean isCSVFormat, String jmeterDirectoryPath) throws MojoExecutionException {
        JMeterArgumentsArray testArgs = new JMeterArgumentsArray(disableGUI, jmeterDirectoryPath).setResultsDirectory(this.resultsDirectory.getAbsolutePath()).setResultFileOutputFormatIsCSV(isCSVFormat).setProxyConfig(this.proxyConfig).setLogRootOverride(this.overrideRootLogLevel).setLogsDirectory(this.logsDirectory.getAbsolutePath()).addACustomPropertiesFiles(this.customPropertiesFiles);
        if (this.generateReports && disableGUI) {
            testArgs.setReportsDirectory(this.reportDirectory.getAbsolutePath());
        }
        if (this.testResultsTimestamp) {
            testArgs.setResultsTimestamp(true).appendTimestamp(this.appendResultsTimestamp).setResultsFileNameDateFormat(this.resultsFileNameDateFormat);
        }
        return testArgs;
    }

    protected void loadMavenProxy() {
        if (null == this.settings) {
            return;
        }
        Proxy mvnProxy = this.settings.getActiveProxy();
        if (mvnProxy != null) {
            ProxyConfiguration newProxyConfiguration = new ProxyConfiguration();
            newProxyConfiguration.setHost(mvnProxy.getHost());
            newProxyConfiguration.setPort(mvnProxy.getPort());
            newProxyConfiguration.setUsername(mvnProxy.getUsername());
            newProxyConfiguration.setPassword(mvnProxy.getPassword());
            newProxyConfiguration.setHostExclusions(mvnProxy.getNonProxyHosts());
            this.proxyConfig = newProxyConfiguration;
            this.getLog().info((CharSequence)"Maven proxy loaded successfully");
        } else {
            this.getLog().warn((CharSequence)"No maven proxy found, however useMavenProxy is set to true!");
        }
    }

    static void copyFilesInTestDirectory(File sourceDirectory, File destinationDirectory) throws MojoExecutionException {
        try {
            FileUtils.copyDirectory((File)sourceDirectory, (File)destinationDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

