/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.scheduler;

import io.perfana.eventscheduler.EventScheduler;
import io.perfana.eventscheduler.EventSchedulerBuilder;
import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.api.SchedulerExceptionHandler;
import io.perfana.eventscheduler.api.SchedulerExceptionType;
import io.perfana.eventscheduler.api.config.EventSchedulerConfig;
import io.perfana.eventscheduler.api.config.TestContext;
import io.perfana.eventscheduler.exception.EventCheckFailureException;
import io.perfana.eventscheduler.exception.handler.AbortSchedulerException;
import io.perfana.eventscheduler.exception.handler.KillSwitchException;
import java.time.Duration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="test", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class EventSchedulerMojo
extends AbstractMojo {
    private final Object eventSchedulerLock = new Object();
    private EventScheduler eventScheduler;
    private volatile SchedulerExceptionType schedulerExceptionType = SchedulerExceptionType.NONE;
    @Parameter(required=true)
    EventSchedulerConfig eventSchedulerConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.getLog().info((CharSequence)"Execute event-scheduler-maven-plugin");
        if (this.eventSchedulerConfig != null && !this.eventSchedulerConfig.isSchedulerEnabled()) {
            this.getLog().info((CharSequence)"EventScheduler is disabled.");
            return;
        }
        boolean abortEventScheduler = false;
        this.eventScheduler = EventSchedulerMojo.createEventScheduler(this.eventSchedulerConfig, this.getLog());
        try {
            SchedulerExceptionHandler schedulerExceptionHandler = new SchedulerExceptionHandler(){

                public void kill(String message) {
                    EventSchedulerMojo.this.getLog().info((CharSequence)("Killing running process, message: " + message));
                    EventSchedulerMojo.this.schedulerExceptionType = SchedulerExceptionType.KILL;
                }

                public void abort(String message) {
                    EventSchedulerMojo.this.getLog().info((CharSequence)("Aborting running process, message: " + message));
                    EventSchedulerMojo.this.schedulerExceptionType = SchedulerExceptionType.ABORT;
                }

                public void stop(String message) {
                    EventSchedulerMojo.this.getLog().info((CharSequence)("Stop running process, message: " + message));
                    EventSchedulerMojo.this.schedulerExceptionType = SchedulerExceptionType.STOP;
                }
            };
            this.startScheduler(this.eventScheduler, schedulerExceptionHandler);
            TestContext testContext = this.eventScheduler.getEventSchedulerContext().getTestContext();
            Duration rampupTime = testContext.getRampupTime();
            Duration constantLoad = testContext.getConstantLoadTime();
            Duration duration = rampupTime.plus(constantLoad);
            long stopTimestamp = System.currentTimeMillis() + duration.toMillis();
            this.getLog().info((CharSequence)("The event-scheduler-maven-plugin will now wait for " + duration + " for scheduler to finish."));
            boolean justKeepLoopin = true;
            while (System.currentTimeMillis() < stopTimestamp && justKeepLoopin) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.getLog().warn((CharSequence)"Sleep got interrupted: stop wait loop.");
                    justKeepLoopin = false;
                }
                if (this.schedulerExceptionType == SchedulerExceptionType.KILL) {
                    throw new KillSwitchException("Rethrow KillSwitchException from wait loop in event-scheduler-maven-plugin.");
                }
                if (this.schedulerExceptionType == SchedulerExceptionType.ABORT) {
                    throw new AbortSchedulerException("Rethrow AbortSchedulerException from wait loop in event-scheduler-maven-plugin.");
                }
                if (this.schedulerExceptionType != SchedulerExceptionType.STOP) continue;
                this.getLog().info((CharSequence)"Got stop test run request from all ContinueOnKeepAliveParticipants.");
                this.eventScheduler.stopSession();
                justKeepLoopin = false;
            }
            this.getLog().info((CharSequence)("The event-scheduler-maven-plugin has waited for " + duration + ". Scheduler will be stopped."));
        }
        catch (Exception e) {
            if (e instanceof KillSwitchException) {
                this.getLog().info((CharSequence)"KillSwitchException found, setting abortEventScheduler to true.");
                abortEventScheduler = true;
            } else {
                this.getLog().warn((CharSequence)"Inside catch exception", (Throwable)e);
                if (this.eventSchedulerConfig.isFailOnError()) {
                    this.getLog().debug((CharSequence)">>> Fail on error is enabled (true), setting abortEventScheduler to true.");
                    abortEventScheduler = true;
                } else {
                    this.getLog().warn((CharSequence)"There were some errors, but failOnError was set to false: build will not fail.");
                }
            }
        }
        finally {
            if (this.eventScheduler != null) {
                Object e = this.eventSchedulerLock;
                synchronized (e) {
                    if (!this.eventScheduler.isSessionStopped()) {
                        if (abortEventScheduler) {
                            this.getLog().debug((CharSequence)">>> Abort is called in finally: abortEventScheduler is true");
                            this.eventScheduler.abortSession();
                        } else {
                            this.getLog().debug((CharSequence)">>> Stop session (because isSessionStopped() is false and abortEventScheduler is false)");
                            this.eventScheduler.stopSession();
                        }
                    }
                }
            }
        }
        if (this.eventScheduler != null) {
            try {
                this.getLog().debug((CharSequence)">>> Call check results");
                this.eventScheduler.checkResults();
            }
            catch (EventCheckFailureException e) {
                this.getLog().debug((CharSequence)(">>> EventCheckFailureException: " + e.getMessage()));
                if (!this.eventSchedulerConfig.isContinueOnEventCheckFailure()) {
                    throw e;
                }
                this.getLog().warn((CharSequence)("EventCheck failures found, but continue on event check failure is true:" + e.getMessage()));
            }
        }
    }

    private void startScheduler(EventScheduler eventScheduler, SchedulerExceptionHandler schedulerExceptionHandler) {
        eventScheduler.addKillSwitch(schedulerExceptionHandler);
        eventScheduler.startSession();
        this.addShutdownHookForEventScheduler(eventScheduler);
    }

    private void addShutdownHookForEventScheduler(EventScheduler eventScheduler) {
        Thread main = Thread.currentThread();
        Runnable shutdowner = () -> {
            EventScheduler eventScheduler2 = eventScheduler;
            synchronized (eventScheduler2) {
                if (!eventScheduler.isSessionStopped()) {
                    this.getLog().info((CharSequence)"Shutdown Hook: abort event scheduler session!");
                    eventScheduler.abortSession();
                }
            }
            try {
                main.join(4000L);
            }
            catch (InterruptedException e) {
                this.getLog().warn((CharSequence)"Interrupt while waiting for abort to finish.");
                Thread.currentThread().interrupt();
            }
        };
        Thread eventSchedulerShutdownThread = new Thread(shutdowner, "eventSchedulerShutdownThread");
        Runtime.getRuntime().addShutdownHook(eventSchedulerShutdownThread);
    }

    private static EventScheduler createEventScheduler(final EventSchedulerConfig eventSchedulerConfig, final Log log) {
        EventLogger logger = new EventLogger(){

            public void info(String message) {
                log.info((CharSequence)message);
            }

            public void warn(String message) {
                log.warn((CharSequence)message);
            }

            public void error(String message) {
                log.error((CharSequence)message);
            }

            public void error(String message, Throwable throwable) {
                log.error((CharSequence)message, throwable);
            }

            public void debug(String message) {
                if (this.isDebugEnabled()) {
                    log.debug((CharSequence)message);
                }
            }

            public boolean isDebugEnabled() {
                return eventSchedulerConfig.isDebugEnabled();
            }
        };
        return EventSchedulerBuilder.of((EventSchedulerConfig)eventSchedulerConfig, (EventLogger)logger);
    }
}

