/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.spring4;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.spring4.PebbleView;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class PebbleViewResolver
extends AbstractTemplateViewResolver
implements InitializingBean {
    private String characterEncoding = "UTF-8";
    private PebbleEngine pebbleEngine;

    public PebbleViewResolver() {
        this.setViewClass(this.requiredViewClass());
    }

    public void afterPropertiesSet() {
        Loader templateLoader = this.pebbleEngine.getLoader();
        templateLoader.setPrefix(this.getPrefix());
        templateLoader.setSuffix(this.getSuffix());
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    @Required
    public void setPebbleEngine(PebbleEngine pebbleEngine) {
        this.pebbleEngine = pebbleEngine;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        PebbleView view = (PebbleView)super.buildView(viewName);
        view.setTemplateName(viewName);
        view.setPebbleEngine(this.pebbleEngine);
        view.setCharacterEncoding(this.characterEncoding);
        return view;
    }

    protected Class<?> requiredViewClass() {
        return PebbleView.class;
    }
}

