/*
 * Decompiled with CFR 0.152.
 */
package io.pdfdata.model.ops;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.pdfdata.model.Bounds;
import io.pdfdata.model.Entity;
import io.pdfdata.model.Operation;
import io.pdfdata.model.TemplateMatch;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PageTemplates
extends Operation {
    private Map<String, Template> templates = new HashMap<String, Template>();

    public PageTemplates() {
        super("page-templates");
    }

    PageTemplates(Map<String, Template> templates) {
        this();
        this.templates = templates;
    }

    public PageTemplates withTemplate(String name, Template t) {
        return this.withTemplates(Collections.singletonMap(name, t));
    }

    private PageTemplates withTemplates(Map<String, Template> templates) {
        HashMap<String, Template> copy = new HashMap<String, Template>(this.templates);
        copy.putAll(templates);
        return new PageTemplates(copy);
    }

    public Map<String, Template> getTemplates() {
        return Collections.unmodifiableMap(this.templates);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PageTemplates that = (PageTemplates)o;
        return this.templates.equals(that.templates);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.templates.hashCode();
        return result;
    }

    public static class Result
    extends Operation.Result {
        private List<TemplateMatch> data;

        public Result() {
            super("page-templates");
        }

        public List<TemplateMatch> getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return this.data.equals(result.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }

    public static class Region
    extends Entity {
        private Bounds bounds;
        @JsonProperty(value="match")
        private String match;
        @JsonProperty(value="contains")
        private String contains;

        Region() {
        }

        public Region(Bounds bounds) {
            this.bounds = bounds;
        }

        public Region(double lx, double by, double rx, double ty) {
            this(new Bounds(lx, by, rx, ty));
        }

        Region(Bounds bounds, String match, String contains) {
            this.bounds = bounds;
            this.match = match;
            this.contains = contains;
        }

        public Region matchingRegex(String match) {
            return new Region(this.bounds, match, this.contains);
        }

        public Region containingString(String contains) {
            return new Region(this.bounds, this.match, contains);
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        @JsonProperty(value="match")
        public String getMatchingRegex() {
            return this.match;
        }

        @JsonProperty(value="contains")
        public String getContainingString() {
            return this.contains;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Region region = (Region)o;
            if (!this.bounds.equals(region.bounds)) {
                return false;
            }
            if (this.match != null ? !this.match.equals(region.match) : region.match != null) {
                return false;
            }
            return this.contains != null ? this.contains.equals(region.contains) : region.contains == null;
        }

        public int hashCode() {
            int result = this.bounds.hashCode();
            result = 31 * result + (this.match != null ? this.match.hashCode() : 0);
            result = 31 * result + (this.contains != null ? this.contains.hashCode() : 0);
            return result;
        }
    }

    public static class Template
    extends Entity {
        private Map<String, Region> regions = new HashMap<String, Region>();
        private Integer pageNumber;

        public Template() {
        }

        Template(Map<String, Region> regions, Integer pageNumber) {
            this.regions = regions;
            this.pageNumber = pageNumber;
        }

        @JsonProperty(value="pagenum")
        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public Map<String, Region> getRegions() {
            return Collections.unmodifiableMap(this.regions);
        }

        public Template withRegion(String name, Region region) {
            return this.withRegions(Collections.singletonMap(name, region));
        }

        public Template withRegions(Map<String, Region> regions) {
            HashMap<String, Region> copy = new HashMap<String, Region>(this.regions);
            copy.putAll(regions);
            return new Template(copy, this.pageNumber);
        }

        public Template restrictToPage(int pageNumber) {
            return new Template(this.regions, pageNumber);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            if (!this.regions.equals(template.regions)) {
                return false;
            }
            return this.pageNumber != null ? this.pageNumber.equals(template.pageNumber) : template.pageNumber == null;
        }

        public int hashCode() {
            int result = this.regions.hashCode();
            result = 31 * result + (this.pageNumber != null ? this.pageNumber.hashCode() : 0);
            return result;
        }
    }
}

