/*
 * Decompiled with CFR 0.152.
 */
package io.pdfdata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.pdfdata.API;
import io.pdfdata.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneOffset;

public class JSON {
    private static final ObjectMapper MAPPER = JSON.configureMapper(new ObjectMapper());
    private final API pdfdata;
    private final ObjectMapper mapper;
    private final ObjectReader reader;
    private static final ThreadLocal<API> TL_API = new ThreadLocal();

    public static API currentAPI() {
        API pdfdata = TL_API.get();
        assert (pdfdata != null);
        return pdfdata;
    }

    public JSON(API pdfdata) {
        this.pdfdata = pdfdata;
        this.mapper = JSON.configureMapper(new ObjectMapper());
        this.reader = this.mapper.reader();
    }

    private static ObjectMapper configureMapper(ObjectMapper mapper) {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule m = new SimpleModule();
        m.addSerializer((JsonSerializer)new InstantSerializer());
        m.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer());
        m.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<Enum> modifyEnumDeserializer(DeserializationConfig config, final JavaType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                return new JsonDeserializer<Enum>(){

                    public Enum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                        Class rawClass = type.getRawClass();
                        return Enum.valueOf(rawClass, jp.getValueAsString().toUpperCase());
                    }
                };
            }
        });
        m.addSerializer(Enum.class, (JsonSerializer)new StdSerializer<Enum>(Enum.class){

            public void serialize(Enum value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeString(value.name().toLowerCase());
            }
        });
        mapper.registerModule((Module)m);
        return mapper;
    }

    private void startMapping() {
        TL_API.set(this.pdfdata);
    }

    public String to(Object obj) throws IOException {
        return JSON.to(obj, this.mapper);
    }

    public static String to0(Object obj) throws IOException {
        return JSON.to(obj, MAPPER);
    }

    public static String to(Object obj, ObjectMapper mapper) throws IOException {
        StringWriter out = new StringWriter();
        mapper.writeValue((Writer)out, obj);
        return out.toString();
    }

    public <T> T from(InputStream is, TypeReference<T> resultType) throws IOException {
        return this.from(Util.readString(is), resultType);
    }

    public <T> T from(InputStream is, Class<T> cls) throws IOException {
        return this.from(Util.readString(is), cls);
    }

    public <T> T from(String data, Class<T> cls) throws IOException {
        this.startMapping();
        return (T)this.reader.readValue(this.reader.getFactory().createParser(data), cls);
    }

    public <T> T from(String data, TypeReference<T> resultType) throws IOException {
        this.startMapping();
        return (T)this.reader.readValue(this.reader.getFactory().createParser(data), resultType);
    }

    public <T> T from(JsonNode responseBody, TypeReference<T> resultType) throws IOException {
        this.startMapping();
        return (T)this.reader.readValue((JsonParser)new TreeTraversingParser(responseBody, (ObjectCodec)this.reader), resultType);
    }

    public <T> T from(JsonNode responseBody, Class<T> resultType) throws IOException {
        this.startMapping();
        return (T)this.reader.readValue((JsonParser)new TreeTraversingParser(responseBody, (ObjectCodec)this.reader), resultType);
    }

    static class InstantDeserializer
    extends StdDeserializer<Instant> {
        InstantDeserializer() {
            super(Instant.class);
        }

        public Instant deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return API.parseDate(jsonParser.getText());
        }
    }

    static class InstantSerializer
    extends StdSerializer<Instant> {
        InstantSerializer() {
            super(Instant.class);
        }

        public void serialize(Instant t, JsonGenerator jg, SerializerProvider serializerProvider) throws IOException {
            jg.writeString(API.INSTANT_FORMATTER.format(t.atOffset(ZoneOffset.UTC)));
        }
    }
}

