/*
 * Decompiled with CFR 0.152.
 */
package io.pdfdata.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.pdfdata.model.Entity;
import java.io.IOException;

@JsonDeserialize(using=DimensionsDeserializer.class)
public class Dimensions
extends Entity {
    private final int width;
    private final int height;

    public Dimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dimensions that = (Dimensions)o;
        if (this.width != that.width) {
            return false;
        }
        return this.height == that.height;
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        return result;
    }

    static class DimensionsDeserializer
    extends StdDeserializer<Dimensions> {
        DimensionsDeserializer() {
            super(Dimensions.class);
        }

        public Dimensions deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode array = (JsonNode)jp.getCodec().readTree(jp);
            if (array.isArray() && array.size() == 2) {
                return new Dimensions(array.get(0).asInt(), array.get(1).asInt());
            }
            throw new IOException("Invalid dimensions data, must be array of 2 integers");
        }
    }
}

