/*
 * Decompiled with CFR 0.152.
 */
package io.pdfdata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import io.pdfdata.API;
import io.pdfdata.APIException;
import io.pdfdata.JSON;
import io.pdfdata.MultipartProcessor;
import io.pdfdata.Network;
import io.pdfdata.model.Operation;
import io.pdfdata.model.ResponseEntity;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Request {
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_READ_TIMEOUT = 80000;
    final API pdfdata;
    private int connectTimeout = 30000;
    private int readTimeout = 80000;

    Request(API pdfdata) {
        this.pdfdata = pdfdata;
    }

    <T> T doRequest(Network.Method verb, String path, TypeReference<T> resultType) throws IOException {
        return this.doRequest(verb, path, new HashMap<String, Object>(), resultType);
    }

    <T> T doRequest(Network.Method verb, String path, Map<String, Object> params, TypeReference<T> resultType) throws IOException {
        return this.doRequest(verb, path, params, new HashMap<String, String>(), resultType);
    }

    private static boolean isOperationsList(Object x) {
        if (x instanceof List) {
            for (Object y : (List)x) {
                if (y instanceof Operation) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    InputStream doStreamGet(String path) throws IOException {
        URL url = new URL(this.pdfdata.getEndpoint(), path);
        HttpURLConnection conn = Network.openConnection(Network.Method.GET, url, null, this.pdfdata);
        int status = conn.getResponseCode();
        String contentType = String.valueOf(conn.getHeaderField("Content-Type"));
        if (status >= 200 && status < 300) {
            return conn.getInputStream();
        }
        if (contentType.equals("application/json")) {
            InputStream is = conn.getErrorStream();
            throw new APIException(this.pdfdata.json.from(is, new TypeReference<Map<String, Object>>(){}), status, Network.Method.GET, url, null, Network.mergeHeaders(null));
        }
        throw new APIException(String.format("%s request to %s produced a failure response with an unparseable Content-Type: %s.", new Object[]{Network.Method.GET, url.toExternalForm(), contentType}), status, Network.Method.GET, url, null, Network.mergeHeaders(null));
    }

    <T> T doRequest(Network.Method verb, String path, Map<String, Object> params, Map<String, String> headers, TypeReference<T> resultType) throws IOException {
        String queryString = verb == Network.Method.GET ? Network.queryString(params) : "";
        URL url = new URL(this.pdfdata.getEndpoint().toExternalForm() + path + queryString);
        String boundary = null;
        if (verb == Network.Method.POST) {
            boundary = MultipartProcessor.getBoundary();
            headers.put("Content-Type", "multipart/form-data; boundary=" + boundary);
        }
        HttpURLConnection conn = Network.openConnection(verb, url, headers, this.pdfdata);
        if (verb == Network.Method.POST) {
            MultipartProcessor mpp = new MultipartProcessor(conn, boundary, "UTF-8");
            for (Map.Entry<String, Object> param : params.entrySet()) {
                if (Request.isOperationsList(param.getValue())) {
                    mpp.addFormField(param.getKey(), JSON.to0(param.getValue()));
                    continue;
                }
                for (Object v : (Collection)(param.getValue() instanceof Collection ? param.getValue() : Collections.singleton(param.getValue()))) {
                    if (v == null) continue;
                    if (v instanceof String) {
                        mpp.addFormField(param.getKey(), (String)v);
                        continue;
                    }
                    if (v instanceof File) {
                        mpp.addFileField(param.getKey(), (File)v);
                        continue;
                    }
                    if (v instanceof Number) {
                        mpp.addFormField(param.getKey(), v.toString());
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("Illegal param value type %s provided for %s", v.getClass().getName(), param.getKey()));
                }
            }
            mpp.finish();
        }
        int status = conn.getResponseCode();
        String contentType = String.valueOf(conn.getHeaderField("Content-Type"));
        if (contentType.equals("application/json")) {
            InputStream is;
            if (status >= 200 && status < 300) {
                is = conn.getInputStream();
                JsonNode body = this.pdfdata.json.from(is, JsonNode.class);
                T response = this.pdfdata.json.from(body, resultType);
                if (response instanceof List) {
                    List listResponse = (List)response;
                    int len = listResponse.size();
                    for (int i = 0; i < len; ++i) {
                        Object resp = listResponse.get(i);
                        if (!this.pdfdata.isCaptureResponseBodies()) continue;
                        ((ResponseEntity)resp).setResponseBody(body.get(i));
                    }
                } else {
                    if (response instanceof Collection) {
                        throw new IOException("Unexpected response type " + response.getClass());
                    }
                    if (this.pdfdata.isCaptureResponseBodies()) {
                        ((ResponseEntity)response).setResponseBody(body);
                    }
                }
                return response;
            }
            is = conn.getErrorStream();
            throw new APIException(this.pdfdata.json.from(is, new TypeReference<Map<String, Object>>(){}), status, verb, url, params, Network.mergeHeaders(headers));
        }
        throw new APIException(String.format("%s request to %s produced a response with an unexpected Content-Type: %s.", new Object[]{verb, url.toExternalForm(), contentType}), status, verb, url, params, Network.mergeHeaders(headers));
    }
}

