/*
 * Decompiled with CFR 0.152.
 */
package io.pdfdata.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.pdfdata.API;
import io.pdfdata.JSON;
import io.pdfdata.model.AResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

@JsonDeserialize
public class Resource
extends AResource {
    @JsonDeserialize(using=ServiceRelativeURLDeserializer.class)
    private URL url;
    private String mimetype;
    @JsonIgnore
    private final API pdfdata = JSON.currentAPI();

    public URL getUrl() {
        return this.url;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public InputStream get() throws IOException {
        return this.pdfdata.resources().byURL(this.url);
    }

    private static class ServiceRelativeURLDeserializer
    extends StdDeserializer<URL> {
        public ServiceRelativeURLDeserializer() {
            super(URL.class);
        }

        public URL deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new URL(JSON.currentAPI().getEndpoint(), p.getText());
        }
    }
}

