/*
 * Decompiled with CFR 0.152.
 */
package io.pdfdata;

import com.fasterxml.jackson.core.type.TypeReference;
import io.pdfdata.API;
import io.pdfdata.Network;
import io.pdfdata.Request;
import io.pdfdata.Util;
import io.pdfdata.model.Operation;
import io.pdfdata.model.Proc;
import io.pdfdata.model.ProcessedDocument;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ProcsRequest
extends Request {
    private static final String base = "/procs";
    private static final TypeReference<Proc> TYPEREF = new TypeReference<Proc>(){};
    private static final TypeReference<List<Proc>> TYPEREF_LIST = new TypeReference<List<Proc>>(){};
    private static final int DEFAULT_WAIT = 30;
    private static final Set<String> RESOURCEFUL_OPS = Util.setFrom("attachments", "images", "xmp-metadata");

    ProcsRequest(API pdfdata) {
        super(pdfdata);
    }

    private Proc registerResources(Proc proc) throws IOException {
        if (proc.getDocuments() != null) {
            ArrayList<Integer> resourceOps = new ArrayList<Integer>();
            int len = proc.getOperations().size();
            for (int i = 0; i < len; ++i) {
                Operation op = proc.getOperations().get(i);
                if (!RESOURCEFUL_OPS.contains(op.getOperationName())) continue;
                resourceOps.add(i);
            }
            if (!resourceOps.isEmpty()) {
                for (ProcessedDocument d : proc.getDocuments()) {
                    Iterator iterator = resourceOps.iterator();
                    while (iterator.hasNext()) {
                        int opNumber = (Integer)iterator.next();
                        d.getResults().get(opNumber).registerResources();
                    }
                }
            }
        }
        return proc;
    }

    public Proc byID(String procid) throws IOException {
        return this.registerResources(this.doRequest(Network.Method.GET, "/procs/" + procid, TYPEREF));
    }

    public ProcCreationBuilder configure() {
        return new ProcCreationBuilder();
    }

    public class ProcCreationBuilder {
        private final Set<File> files;
        private final Set<String> documentIDs;
        private final Set<String> documentTags;
        private final ArrayList<Operation> operations;
        private final int wait;

        ProcCreationBuilder() {
            this(new HashSet<File>(), new HashSet<String>(), new HashSet<String>(), new ArrayList<Operation>(), 30);
        }

        ProcCreationBuilder(Set<File> files, Set<String> docIDs, Set<String> documentTags, ArrayList<Operation> operations, int wait) {
            this.files = files == null ? new HashSet() : files;
            this.documentIDs = docIDs == null ? new HashSet() : docIDs;
            this.documentTags = documentTags == null ? new HashSet() : documentTags;
            this.operations = operations == null ? new ArrayList() : operations;
            this.wait = wait;
        }

        public Proc start() throws IOException {
            Map<String, Object> params = Util.kvmap("docid", this.documentIDs, "file", this.files, "tag", this.documentTags);
            ArrayList<String> documentIdentifiersUsed = new ArrayList<String>();
            for (Map.Entry<String, Object> param : params.entrySet()) {
                if (((Set)param.getValue()).size() <= 0) continue;
                documentIdentifiersUsed.add(param.getKey());
            }
            switch (documentIdentifiersUsed.size()) {
                case 1: {
                    break;
                }
                case 0: {
                    throw new IllegalArgumentException("No source documents were specified, cannot create proc. You must provide: a set of files to upload and process OR a set of tags used to identify previously-uploaded source documents OR a set of document IDs. Use one of `.withFiles()`, `.withTags()`, or `.withDocumentIDs()` prior to attempting to `.start()` the proc.");
                }
                default: {
                    throw new IllegalArgumentException(String.format("Attempted to start a proc with more than one type of identifier of source documents: %s. Only *one* of new files to upload, document tags, or document IDs can be provided when configuring a new proc.", documentIdentifiersUsed));
                }
            }
            if (this.wait != 30) {
                params.put("wait", this.wait);
            }
            params.put("operations", this.operations);
            return ProcsRequest.this.registerResources((Proc)ProcsRequest.this.doRequest(Network.Method.POST, ProcsRequest.base, params, TYPEREF));
        }

        public ProcCreationBuilder withDocumentIDs(String ... docIDs) {
            return this.withDocumentIDs(Arrays.asList(docIDs));
        }

        public ProcCreationBuilder withDocumentIDs(Collection<String> docIDs) {
            return new ProcCreationBuilder(this.files, Util.union(this.documentIDs, Util.setFrom(docIDs)), this.documentTags, this.operations, this.wait);
        }

        public ProcCreationBuilder withFiles(File ... files) {
            return this.withFiles(Arrays.asList(files));
        }

        public ProcCreationBuilder withFiles(String ... paths) {
            return this.withFiles(Arrays.asList(paths));
        }

        public ProcCreationBuilder withFiles(Collection paths) {
            return new ProcCreationBuilder(Util.union(this.files, paths.stream().map(s -> s instanceof File ? s : new File((String)s)).collect(Collectors.toSet())), this.documentIDs, this.documentTags, this.operations, this.wait);
        }

        public ProcCreationBuilder withTags(String ... tags) {
            return this.withTags(Arrays.asList(tags));
        }

        public ProcCreationBuilder withTags(Collection<String> tags) {
            return new ProcCreationBuilder(this.files, this.documentIDs, Util.union(this.documentTags, Util.setFrom(tags)), this.operations, this.wait);
        }

        public ProcCreationBuilder withOperations(Operation ... operations) {
            return this.withOperations(Arrays.asList(operations));
        }

        public ProcCreationBuilder withOperations(Collection<Operation> operations) {
            ArrayList<Operation> ops = new ArrayList<Operation>(this.operations);
            ops.addAll(operations);
            return new ProcCreationBuilder(this.files, this.documentIDs, this.documentTags, ops, this.wait);
        }

        public ProcCreationBuilder withWait(int seconds) {
            return new ProcCreationBuilder(this.files, this.documentIDs, this.documentTags, this.operations, seconds);
        }
    }
}

