/*
 * Decompiled with CFR 0.152.
 */
package io.parapet.p2p;

import com.google.protobuf.InvalidProtocolBufferException;
import io.parapet.p2p.InetAddress;
import io.parapet.p2p.Protocol;
import io.parapet.p2p.utils.Throwables;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.nio.channels.SelectableChannel;
import java.util.Optional;
import org.zeromq.ZMQ;
import scala.Tuple2;

public class Udplib {
    private final String multicastIp;
    private final int multicastPort;
    private DatagramChannel dc;
    private MembershipKey membershipKey;
    private InetSocketAddress target;
    private ByteBuffer _buf = ByteBuffer.allocate(48);

    public Udplib(InetAddress inetAddress) {
        this.multicastIp = inetAddress.ip;
        this.multicastPort = inetAddress.port;
        try {
            this.init();
        }
        catch (Exception exception) {
            this.close();
            throw new RuntimeException(exception);
        }
    }

    public ZMQ.PollItem createPollItem() {
        return new ZMQ.PollItem((SelectableChannel)this.dc, 1);
    }

    public void send(Protocol.Beacon beacon) {
        this.send(beacon.toByteArray());
    }

    public void send(byte[] byArray) {
        try {
            this.dc.send(ByteBuffer.wrap(byArray), this.target);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Optional<Tuple2<Protocol.Beacon, SocketAddress>> receive() {
        Optional<SocketAddress> optional = this.receive(this._buf);
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        try {
            Protocol.Beacon beacon = Protocol.Beacon.parseFrom(this._buf.array());
            return Optional.of(Tuple2.apply((Object)beacon, (Object)optional.get()));
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            invalidProtocolBufferException.printStackTrace();
            return Optional.empty();
        }
    }

    public Optional<SocketAddress> receive(ByteBuffer byteBuffer) {
        try {
            byteBuffer.clear();
            return Optional.ofNullable(this.dc.receive(byteBuffer));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void init() throws Exception {
        NetworkInterface networkInterface = this.getNetworkInterface();
        this.dc = ((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).bind(new InetSocketAddress(this.multicastPort)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, networkInterface);
        java.net.InetAddress inetAddress = java.net.InetAddress.getByName(this.multicastIp);
        this.dc.configureBlocking(false);
        this.membershipKey = this.dc.join(inetAddress, networkInterface);
        this.target = new InetSocketAddress(inetAddress, this.multicastPort);
    }

    public void close() {
        if (this.dc != null) {
            Throwables.suppressError(() -> this.dc.close());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetworkInterface getNetworkInterface() {
        try (MulticastSocket multicastSocket = new MulticastSocket();){
            NetworkInterface networkInterface = multicastSocket.getNetworkInterface();
            return networkInterface;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

