/*
 * Decompiled with CFR 0.152.
 */
package io.parapet.p2p;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.parapet.p2p.Config;
import io.parapet.p2p.InetAddress;
import io.parapet.p2p.Interface;
import io.parapet.p2p.Peer;
import io.parapet.p2p.Protocol;
import io.parapet.p2p.Udplib;
import io.parapet.p2p.utils.Throwables;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;
import org.zeromq.ZThread;
import scala.Tuple2;

public class Node
implements Interface {
    private final ZContext ctx = new ZContext();
    private final ZMQ.Socket pipe;
    private final String id;
    private final InterfaceAgent agent;

    public Node(Config config) {
        this.agent = new InterfaceAgent(config);
        this.pipe = ZThread.fork((ZContext)this.ctx, (ZThread.IAttachedRunnable)this.agent, (Object[])new Object[0]);
        this.id = config.nodeId;
    }

    public Peer getPeer(String string) {
        return (Peer)this.agent.peers.get(string);
    }

    public Collection<Peer> getPeers() {
        return this.agent.peers.values();
    }

    public String getId() {
        return this.id;
    }

    public String getInfo() {
        return String.format("Node[id=%s, ip=%s, port=%d]", this.id, this.agent.selfIp, this.agent.selfPort);
    }

    public void stop() {
        try {
            this.ctx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void send(String string, byte[] byArray) {
        ByteString byteString = Protocol.Whisper.newBuilder().setPeerId(string).setData(ByteString.copyFrom((byte[])byArray)).build().toByteString();
        byte[] byArray2 = Protocol.Command.newBuilder().setPeerId(this.id).setCmdType(Protocol.CmdType.WHISPER).setData(byteString).build().toByteArray();
        this.pipe.send(byArray2);
    }

    @Override
    public void send(byte[] byArray) {
        ByteString byteString = Protocol.Shout.newBuilder().setGroup("").setData(ByteString.copyFrom((byte[])byArray)).build().toByteString();
        byte[] byArray2 = Protocol.Command.newBuilder().setPeerId(this.id).setCmdType(Protocol.CmdType.SHOUT).setData(byteString).build().toByteArray();
        this.pipe.send(byArray2);
    }

    @Override
    public Protocol.Command receive() {
        try {
            return Protocol.Command.parseFrom(this.pipe.recv());
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new RuntimeException(invalidProtocolBufferException);
        }
    }

    private static String getSelfIP() {
        java.net.InetAddress inetAddress;
        try {
            inetAddress = java.net.InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("failed to retrieve self ip", unknownHostException);
        }
        return inetAddress.getHostAddress();
    }

    private static class InterfaceAgent
    implements ZThread.IAttachedRunnable {
        private Udplib udplib;
        private int selfPort = -1;
        private int version;
        private String selfId;
        private String selfIp;
        private ZMQ.Socket pipe;
        private ZContext ctx;
        private InetAddress multicastAddress;
        private final Map<String, Peer> peers = new ConcurrentHashMap<String, Peer>();
        private ZMQ.Socket router;
        private static final int PING_INTERVAL = 1000;

        InterfaceAgent(Config config) {
            this.version = config.protocolVer;
            this.selfId = config.nodeId;
            this.multicastAddress = new InetAddress(config.multicastIp, config.multicastPort);
        }

        void init(ZMQ.Socket socket, ZContext zContext) {
            this.pipe = socket;
            this.ctx = zContext;
            this.udplib = new Udplib(this.multicastAddress);
            this.router = zContext.createSocket(SocketType.ROUTER);
            this.selfPort = this.bindRouter();
            this.selfIp = Node.getSelfIP();
        }

        private int bindRouter() {
            return this.router.bindToRandomPort("tcp://*", 5555, 6666);
        }

        private void handleBeacon() {
            Optional<Tuple2<Protocol.Beacon, SocketAddress>> optional = this.udplib.receive();
            if (!optional.isPresent()) {
                return;
            }
            Tuple2<Protocol.Beacon, SocketAddress> tuple2 = optional.get();
            Protocol.Beacon beacon = (Protocol.Beacon)tuple2._1;
            InetSocketAddress inetSocketAddress = (InetSocketAddress)tuple2._2;
            if (!this.selfId.equals(beacon.getPeerId())) {
                this.addPeer(beacon.getPeerId(), inetSocketAddress.getHostString(), beacon.getPort());
            }
        }

        private boolean addPeer(String string, String string2, int n) {
            if (!this.peers.containsKey(string)) {
                Peer peer = new Peer(string, string2, n);
                peer.connect(this.selfId, this.ctx);
                this.peers.put(string, peer);
                this.sendToPeer(string, Protocol.CmdType.HELLO, Protocol.Hello.newBuilder().setPort(this.selfPort).setIp(this.selfIp).build().toByteString());
                this.sendJoin(string);
                return true;
            }
            this.peers.get(string).updateExpire();
            return false;
        }

        private void handleControlMsg() {
            try {
                Protocol.Command command = Protocol.Command.parseFrom(this.pipe.recv());
                switch (command.getCmdType()) {
                    case SHOUT: {
                        Protocol.Shout shout = Protocol.Shout.parseFrom(command.getData());
                        if (!shout.getGroup().isEmpty()) break;
                        for (Peer peer : this.peers.values()) {
                            this.sendToPeer(peer.id, Protocol.CmdType.DELIVER, shout.getData());
                        }
                        break;
                    }
                    case WHISPER: {
                        Protocol.Whisper whisper = Protocol.Whisper.parseFrom(command.getData());
                        Peer peer = this.peers.get(whisper.getPeerId());
                        this.sendToPeer(peer.id, Protocol.CmdType.DELIVER, whisper.getData());
                    }
                }
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                invalidProtocolBufferException.printStackTrace();
            }
        }

        private void handleCmd() {
            ZMsg zMsg = ZMsg.recvMsg((ZMQ.Socket)this.router);
            zMsg.popString();
            try {
                Protocol.Command command = Protocol.Command.parseFrom(zMsg.pop().getData());
                switch (command.getCmdType()) {
                    case HELLO: {
                        Protocol.Hello hello = Protocol.Hello.parseFrom(command.getData());
                        this.addPeer(command.getPeerId(), hello.getIp(), hello.getPort());
                        break;
                    }
                    case DELIVER: {
                        if (!this.peers.containsKey(command.getPeerId())) {
                            throw new IllegalStateException(String.format("peer with id=%s doesn't exist", command.getPeerId()));
                        }
                        this.pipe.send(command.toByteArray());
                    }
                }
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                invalidProtocolBufferException.printStackTrace();
            }
        }

        private void sendJoin(String string) {
            this.pipe.send(Protocol.Command.newBuilder().setPeerId(string).setCmdType(Protocol.CmdType.JOINED).build().toByteArray());
        }

        private void sendLeft(String string) {
            this.pipe.send(Protocol.Command.newBuilder().setPeerId(string).setCmdType(Protocol.CmdType.LEFT).build().toByteArray());
        }

        private void sendToPeer(String string, Protocol.CmdType cmdType, ByteString byteString) {
            if (!this.peers.containsKey(string)) {
                throw new IllegalStateException(String.format("Error: peer[id=%s] doesn't exist", string));
            }
            byte[] byArray = Protocol.Command.newBuilder().setPeerId(this.selfId).setCmdType(cmdType).setData(byteString).build().toByteArray();
            this.peers.get((Object)string).socket.send(byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Object[] objectArray, ZContext zContext, ZMQ.Socket socket) {
            Selector selector = null;
            try {
                this.init(socket, zContext);
                selector = Selector.open();
                long l = System.currentTimeMillis();
                ZMQ.PollItem[] pollItemArray = new ZMQ.PollItem[]{this.udplib.createPollItem(), new ZMQ.PollItem(socket, 1), new ZMQ.PollItem(this.router, 1)};
                while (!Thread.currentThread().isInterrupted()) {
                    long l2 = l - System.currentTimeMillis();
                    if (l2 < 0L) {
                        l2 = 0L;
                    }
                    if (ZMQ.poll((Selector)selector, (ZMQ.PollItem[])pollItemArray, (int)3, (long)l2) == -1) {
                        break;
                    }
                    if (pollItemArray[0].isReadable()) {
                        this.handleBeacon();
                    }
                    if (pollItemArray[1].isReadable()) {
                        this.handleControlMsg();
                    }
                    if (pollItemArray[2].isReadable()) {
                        this.handleCmd();
                    }
                    if (System.currentTimeMillis() >= l) {
                        this.udplib.send(Protocol.Beacon.newBuilder().setVersion(this.version).setPort(this.selfPort).setPeerId(this.selfId).build());
                        l = System.currentTimeMillis() + 1000L;
                    }
                    this.reapPeers();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (this.udplib != null) {
                    this.udplib.close();
                }
                if (selector != null) {
                    Throwables.suppressError(selector::close);
                }
            }
        }

        private void reapPeers() {
            Iterator<String> iterator = this.peers.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (System.currentTimeMillis() < this.peers.get((Object)string).expiresAt) continue;
                this.sendLeft(string);
                iterator.remove();
            }
        }
    }
}

