/*
 * Decompiled with CFR 0.152.
 */
package io.parapet.p2p;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MulticastDiscovery {
    public static void main(String[] stringArray) throws Exception {
        String string = System.getenv("MULTICAST_ADDR");
        int n = Integer.parseInt(System.getenv("MULTICAST_PORT"));
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        executorService.submit(new MulticastPublisher(string, n));
        executorService.submit(new MulticastReceiver(string, n)).get();
    }

    private static String getSelfIP() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        return inetAddress.getHostAddress();
    }

    static class MulticastPublisher
    implements Runnable {
        private static final byte[] MESSAGE_BUF = "ping".getBytes();
        private final String addr;
        private final int port;

        MulticastPublisher(String string, int n) {
            this.addr = string;
            this.port = n;
        }

        @Override
        public void run() {
            try (DatagramSocket datagramSocket = new DatagramSocket();){
                InetAddress inetAddress = InetAddress.getByName(this.addr);
                while (!Thread.currentThread().isInterrupted()) {
                    DatagramPacket datagramPacket = new DatagramPacket(MESSAGE_BUF, MESSAGE_BUF.length, inetAddress, this.port);
                    datagramSocket.send(datagramPacket);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    static class MulticastReceiver
    implements Runnable {
        private final byte[] buf = new byte[256];
        private final String addr;
        private final int port;

        MulticastReceiver(String string, int n) {
            this.addr = string;
            this.port = n;
        }

        @Override
        public void run() {
            try (MulticastSocket multicastSocket = new MulticastSocket(this.port);){
                String string = MulticastDiscovery.getSelfIP();
                InetAddress inetAddress = InetAddress.getByName(this.addr);
                multicastSocket.joinGroup(inetAddress);
                while (!Thread.currentThread().isInterrupted()) {
                    DatagramPacket datagramPacket = new DatagramPacket(this.buf, this.buf.length);
                    multicastSocket.receive(datagramPacket);
                    String string2 = new String(datagramPacket.getData(), 0, datagramPacket.getLength());
                    if (datagramPacket.getAddress().getHostAddress().equals(string) || !"end".equals(string2)) continue;
                    break;
                }
                multicastSocket.leaveGroup(inetAddress);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

