/*
 * Decompiled with CFR 0.152.
 */
package io.parapet.p2p;

import java.util.UUID;

public class Config {
    public final String multicastIp;
    public final int multicastPort;
    public final int nodePort;
    public final int protocolVer;
    public final String nodeId;
    public final int maxSocketBindRetries;

    public Config(Builder builder) {
        this.nodeId = builder.nodeId;
        this.multicastIp = builder.multicastIp;
        this.multicastPort = builder.multicastPort;
        this.nodePort = builder.nodePort;
        this.protocolVer = builder.protocolVer;
        this.maxSocketBindRetries = builder.maxSocketBindRetries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String multicastIp;
        private int multicastPort;
        private int nodePort;
        private int protocolVer;
        private int maxSocketBindRetries = 100;
        private String nodeId = UUID.randomUUID().toString();

        public Builder nodeId(String string) {
            this.nodeId = string;
            return this;
        }

        public Builder multicastIp(String string) {
            this.multicastIp = string;
            return this;
        }

        public Builder multicastPort(int n) {
            this.multicastPort = n;
            return this;
        }

        public Builder nodePort(int n) {
            this.nodePort = n;
            return this;
        }

        public Builder protocolVer(int n) {
            this.protocolVer = n;
            return this;
        }

        public Builder maxSocketBindRetries(int n) {
            this.maxSocketBindRetries = n;
            return this;
        }

        public Config build() {
            return new Config(this);
        }
    }
}

