/*
 * Decompiled with CFR 0.152.
 */
package io.parapet.cluster;

import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Timer;
import cats.free.Free;
import com.typesafe.scalalogging.Logger;
import io.parapet.CatsApp;
import io.parapet.Event;
import io.parapet.ParApp;
import io.parapet.ProcessRef;
import io.parapet.cluster.ClusterApp;
import io.parapet.cluster.ClusterApp$AppArgs$;
import io.parapet.cluster.ClusterProcess;
import io.parapet.cluster.Config;
import io.parapet.cluster.Config$;
import io.parapet.core.Context;
import io.parapet.core.Dsl;
import io.parapet.core.DslInterpreter;
import io.parapet.core.EventStore;
import io.parapet.core.EventTransformer;
import io.parapet.core.EventTransformer$;
import io.parapet.core.EventTransformers;
import io.parapet.core.Parallel;
import io.parapet.core.Parapet;
import io.parapet.core.Parapet$;
import io.parapet.core.Process;
import io.parapet.core.api.Cmd;
import io.parapet.core.api.Cmd$;
import io.parapet.core.processes.Coordinator;
import io.parapet.core.processes.Coordinator$;
import io.parapet.core.processes.LeaderElection;
import io.parapet.core.processes.Sub;
import io.parapet.core.processes.Sub$;
import io.parapet.net.Address$;
import io.parapet.net.AsyncClient;
import io.parapet.net.AsyncClient$;
import io.parapet.net.AsyncServer;
import io.parapet.net.AsyncServer$;
import io.parapet.syntax.EventSyntax;
import io.parapet.syntax.FlowSyntax;
import java.io.Serializable;
import java.nio.file.Paths;
import org.zeromq.ZContext;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scopt.OParser;
import scopt.OParser$;
import scopt.OParserBuilder;
import scopt.Read$;

public final class ClusterApp$
implements CatsApp {
    public static final ClusterApp$ MODULE$ = new ClusterApp$();
    private static final ProcessRef coordinatorRef;
    private static final ProcessRef leaderElectionRef;
    private static final ProcessRef netServerRef;
    private static final ProcessRef clusterRef;
    private static final ZContext zmqContext;
    private static final EventTransformer cmdToNetClientSendTransformer;
    private static final OParserBuilder<ClusterApp.AppArgs> builder;
    private static final OParser<BoxedUnit, ClusterApp.AppArgs> parser;
    private static ExecutionContext ec;
    private static ContextShift<IO> contextShift;
    private static Concurrent<IO> ct;
    private static Parallel<IO> parallel;
    private static Timer<IO> timer;
    private static Logger logger;
    private static Parapet.ParConfig config;
    private static EventTransformers.Builder io$parapet$ParApp$$eventTransformers;
    private static EventStore<IO> eventLog;
    private static Dsl.FlowOps<IO, ?> dsl;
    private static volatile byte bitmap$0;

    static {
        Dsl.WithDsl.$init$((Dsl.WithDsl)MODULE$);
        EventSyntax.$init$((EventSyntax)MODULE$);
        FlowSyntax.$init$((FlowSyntax)MODULE$);
        ParApp.$init$((ParApp)MODULE$);
        CatsApp.$init$((CatsApp)MODULE$);
        coordinatorRef = new ProcessRef("coordinator");
        leaderElectionRef = new ProcessRef("leader-election");
        netServerRef = new ProcessRef("net-server");
        clusterRef = new ProcessRef("cluster");
        zmqContext = new ZContext(2);
        cmdToNetClientSendTransformer = EventTransformer$.MODULE$.apply((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Event, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Cmd.coordinator$.Api) {
                    Cmd.coordinator$.Api api = (Cmd.coordinator$.Api)A1;
                    object = new Cmd.netClient$.Send(api.toByteArray(), Cmd.netClient$.Send$.MODULE$.apply$default$2());
                } else if (A1 instanceof Cmd.leaderElection$.Api) {
                    Cmd.leaderElection$.Api api = (Cmd.leaderElection$.Api)A1;
                    object = new Cmd.netClient$.Send(api.toByteArray(), Cmd.netClient$.Send$.MODULE$.apply$default$2());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Event x1) {
                Event event = x1;
                boolean bl = event instanceof Cmd.coordinator$.Api ? true : event instanceof Cmd.leaderElection$.Api;
                return bl;
            }
        });
        builder = OParser$.MODULE$.builder();
        parser = OParser$.MODULE$.sequence(MODULE$.builder().programName("parapet-cluster"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{MODULE$.builder().head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cluster", Parapet$.MODULE$.Version()})), MODULE$.builder().opt('c', "config", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> c.copy((String)x)).text("path to config file")}));
    }

    public DslInterpreter.Interpreter<IO> interpreter(Context<IO> context) {
        return CatsApp.interpreter$((CatsApp)this, context);
    }

    public void unsafeRun(IO<BoxedUnit> io) {
        CatsApp.unsafeRun$((CatsApp)this, io);
    }

    public Object deadLetter() {
        return ParApp.deadLetter$((ParApp)this);
    }

    public Object run() {
        return ParApp.run$((ParApp)this);
    }

    public void eventTransformer(ProcessRef ref, EventTransformer t) {
        ParApp.eventTransformer$((ParApp)this, (ProcessRef)ref, (EventTransformer)t);
    }

    public Object run(String[] args) {
        return ParApp.run$((ParApp)this, (String[])args);
    }

    public void main(String[] args) {
        ParApp.main$((ParApp)this, (String[])args);
    }

    public <A> FlowSyntax.FreeOps<A> FreeOps(Free<?, A> fa) {
        return FlowSyntax.FreeOps$((FlowSyntax)this, fa);
    }

    public EventSyntax.EventOps EventOps(Event e) {
        return EventSyntax.EventOps$((EventSyntax)this, (Event)e);
    }

    public EventSyntax.EventSeqOps EventSeqOps(scala.collection.immutable.Seq<Event> events) {
        return EventSyntax.EventSeqOps$((EventSyntax)this, events);
    }

    private ExecutionContext ec$lzycompute() {
        ClusterApp$ clusterApp$ = this;
        synchronized (clusterApp$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                ec = CatsApp.ec$((CatsApp)this);
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return ec;
    }

    public ExecutionContext ec() {
        return (byte)(bitmap$0 & 1) == 0 ? this.ec$lzycompute() : ec;
    }

    private ContextShift<IO> contextShift$lzycompute() {
        ClusterApp$ clusterApp$ = this;
        synchronized (clusterApp$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                contextShift = CatsApp.contextShift$((CatsApp)this);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return contextShift;
    }

    public ContextShift<IO> contextShift() {
        return (byte)(bitmap$0 & 2) == 0 ? this.contextShift$lzycompute() : contextShift;
    }

    private Concurrent<IO> ct$lzycompute() {
        ClusterApp$ clusterApp$ = this;
        synchronized (clusterApp$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                ct = CatsApp.ct$((CatsApp)this);
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return ct;
    }

    public Concurrent<IO> ct() {
        return (byte)(bitmap$0 & 4) == 0 ? this.ct$lzycompute() : ct;
    }

    private Parallel<IO> parallel$lzycompute() {
        ClusterApp$ clusterApp$ = this;
        synchronized (clusterApp$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                parallel = CatsApp.parallel$((CatsApp)this);
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return parallel;
    }

    public Parallel<IO> parallel() {
        return (byte)(bitmap$0 & 8) == 0 ? this.parallel$lzycompute() : parallel;
    }

    private Timer<IO> timer$lzycompute() {
        ClusterApp$ clusterApp$ = this;
        synchronized (clusterApp$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                timer = CatsApp.timer$((CatsApp)this);
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return timer;
    }

    public Timer<IO> timer() {
        return (byte)(bitmap$0 & 0x10) == 0 ? this.timer$lzycompute() : timer;
    }

    private Logger logger$lzycompute() {
        ClusterApp$ clusterApp$ = this;
        synchronized (clusterApp$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                logger = ParApp.logger$((ParApp)this);
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return logger;
    }

    public Logger logger() {
        return (byte)(bitmap$0 & 0x20) == 0 ? this.logger$lzycompute() : logger;
    }

    public Parapet.ParConfig config() {
        return config;
    }

    public EventTransformers.Builder io$parapet$ParApp$$eventTransformers() {
        return io$parapet$ParApp$$eventTransformers;
    }

    public EventStore<IO> eventLog() {
        return eventLog;
    }

    public void io$parapet$ParApp$_setter_$config_$eq(Parapet.ParConfig x$1) {
        config = x$1;
    }

    public final void io$parapet$ParApp$_setter_$io$parapet$ParApp$$eventTransformers_$eq(EventTransformers.Builder x$1) {
        io$parapet$ParApp$$eventTransformers = x$1;
    }

    public void io$parapet$ParApp$_setter_$eventLog_$eq(EventStore<IO> x$1) {
        eventLog = x$1;
    }

    public Dsl.FlowOps<IO, ?> dsl() {
        return dsl;
    }

    public void io$parapet$core$Dsl$WithDsl$_setter_$dsl_$eq(Dsl.FlowOps<IO, ?> x$1) {
        dsl = x$1;
    }

    private ProcessRef coordinatorRef() {
        return coordinatorRef;
    }

    private ProcessRef leaderElectionRef() {
        return leaderElectionRef;
    }

    private ProcessRef netServerRef() {
        return netServerRef;
    }

    private ProcessRef clusterRef() {
        return clusterRef;
    }

    private ZContext zmqContext() {
        return zmqContext;
    }

    private ProcessRef netClientRef(int id) {
        return new ProcessRef(new StringBuilder(11).append("net-client-").append(id).toString());
    }

    private EventTransformer cmdToNetClientSendTransformer() {
        return cmdToNetClientSendTransformer;
    }

    public IO<scala.collection.immutable.Seq<Process<IO>>> processes(String[] args) {
        return IO$.MODULE$.suspend((Function0 & Serializable)() -> MODULE$.parseArgs(args).flatMap((Function1 & Serializable)appArgs -> MODULE$.loadConfig((ClusterApp.AppArgs)appArgs).flatMap((Function1 & Serializable)config -> MODULE$.createPeerNetClients((Config)config, config.peers()).flatMap((Function1 & Serializable)peerNetClients -> MODULE$.createPeers((Config)config, (scala.collection.immutable.Seq<Tuple2<Config.PeerInfo, ProcessRef>>)((scala.collection.immutable.Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])peerNetClients)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Config.PeerInfo peerInfo = (Config.PeerInfo)tuple2._1();
            AsyncClient p = (AsyncClient)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)peerInfo, (Object)p.ref());
            return tuple22;
        }))).flatMap((Function1 & Serializable)peers -> MODULE$.createCoordinator((Config)config, (LeaderElection.Peers)peers).flatMap((Function1 & Serializable)coordinator -> MODULE$.createSub().flatMap((Function1 & Serializable)sub -> MODULE$.createServer(sub.ref(), (Config)config).flatMap((Function1 & Serializable)netServer -> MODULE$.createLeaderElection((Config)config, MODULE$.clusterRef(), (LeaderElection.Peers)peers).flatMap((Function1 & Serializable)leaderElection -> MODULE$.createClusterProcess((Config)config, (LeaderElection.Peers)peers).flatMap((Function1 & Serializable)cluster2 -> IO$.MODULE$.apply((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Process[]{coordinator, sub, cluster2, leaderElection, netServer})).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])peerNetClients), (Function1 & Serializable)x$1 -> (AsyncClient)x$1._2(), ClassTag$.MODULE$.apply(AsyncClient.class))))).map((Function1 & Serializable)seq -> seq)))))))))));
    }

    public IO<Config> loadConfig(ClusterApp.AppArgs appArgs) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> Config$.MODULE$.load(appArgs.config()));
    }

    public IO<LeaderElection<IO>> createLeaderElection(Config config, ProcessRef sink, LeaderElection.Peers peers) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            LeaderElection.State state = new LeaderElection.State(config.id(), config.address(), MODULE$.netServerRef(), peers, MODULE$.coordinatorRef(), LeaderElection.State$.MODULE$.$lessinit$greater$default$6(), LeaderElection.State$.MODULE$.$lessinit$greater$default$7(), LeaderElection.State$.MODULE$.$lessinit$greater$default$8());
            return new LeaderElection(MODULE$.leaderElectionRef(), state, sink, (Concurrent)IO$.MODULE$.ioConcurrentEffect(MODULE$.contextShift()));
        });
    }

    public IO<ClusterProcess> createClusterProcess(Config config, LeaderElection.Peers peers) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> new ClusterProcess(MODULE$.clusterRef(), config, (Map<String, ProcessRef>)((IterableOnceOps)peers.peers().map((Function1 & Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.id()), (Object)p.ref()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), MODULE$.leaderElectionRef(), (Concurrent<IO>)IO$.MODULE$.ioConcurrentEffect(MODULE$.contextShift())));
    }

    public IO<AsyncServer<IO>> createServer(ProcessRef sink, Config config) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            int port = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(config.address().split(":")[1].trim()));
            return AsyncServer$.MODULE$.apply(MODULE$.netServerRef(), MODULE$.zmqContext(), Address$.MODULE$.tcp("*", port), sink);
        });
    }

    public IO<Coordinator<IO>> createCoordinator(Config config, LeaderElection.Peers peers) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            ProcessRef x$1 = MODULE$.coordinatorRef();
            String x$2 = config.id();
            ProcessRef x$3 = MODULE$.leaderElectionRef();
            Map x$4 = ((IterableOnceOps)peers.peers().map((Function1 & Serializable)peer -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)peer.id()), (Object)peer.ref()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            double x$5 = config.coordinatorThreshold();
            FiniteDuration x$6 = config.coordinatorTimeout();
            Coordinator.Generator x$7 = Coordinator$.MODULE$.$lessinit$greater$default$6();
            return new Coordinator(x$1, x$2, x$3, x$4, x$5, x$7, x$6);
        });
    }

    public IO<Sub<IO>> createSub() {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            void var0;
            Sub sub = Sub$.MODULE$.apply((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Sub.Subscription[]{new Sub.Subscription(MODULE$.coordinatorRef(), (PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Event, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 instanceof Cmd.coordinator$.Api ? BoxedUnit.UNIT : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Event x1) {
                    Event event = x1;
                    boolean bl = event instanceof Cmd.coordinator$.Api;
                    return bl;
                }
            }), new Sub.Subscription(MODULE$.leaderElectionRef(), (PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Event, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = A1 instanceof Cmd.coordinator$.Elected ? BoxedUnit.UNIT : (A1 instanceof Cmd.leaderElection$.Api ? BoxedUnit.UNIT : function1.apply(x2));
                    return (B1)object;
                }

                public final boolean isDefinedAt(Event x2) {
                    Event event = x2;
                    boolean bl = event instanceof Cmd.coordinator$.Elected ? true : event instanceof Cmd.leaderElection$.Api;
                    return bl;
                }
            })})));
            MODULE$.eventTransformer(sub.ref(), EventTransformer$.MODULE$.apply((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Event, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x3;
                    if (A1 instanceof Cmd.netServer$.Message) {
                        Cmd.netServer$.Message message = (Cmd.netServer$.Message)A1;
                        object = Cmd$.MODULE$.apply(message.data());
                    } else {
                        object = function1.apply(x3);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Event x3) {
                    Event event = x3;
                    boolean bl = event instanceof Cmd.netServer$.Message;
                    return bl;
                }
            }));
            return var0;
        });
    }

    public IO<Tuple2<Config.PeerInfo, AsyncClient<IO>>[]> createPeerNetClients(Config config, Config.PeerInfo[] peers) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            void var2_2;
            Tuple2[] netClients = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])peers))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Config.PeerInfo info = (Config.PeerInfo)tuple2._1();
                int index = tuple2._2$mcI$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)info), (Object)AsyncClient$.MODULE$.apply(MODULE$.netClientRef(index), MODULE$.zmqContext(), config.id(), Address$.MODULE$.tcp(info.address()), AsyncClient$.MODULE$.defaultOpts().withSndHWM(1000)));
                return tuple22;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])netClients), (Function1 & Serializable)x0$2 -> {
                ClusterApp$.$anonfun$createPeerNetClients$3(x0$2);
                return BoxedUnit.UNIT;
            });
            return var2_2;
        });
    }

    public IO<LeaderElection.Peers> createPeers(Config config, scala.collection.immutable.Seq<Tuple2<Config.PeerInfo, ProcessRef>> netClients) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> new LeaderElection.Peers(((IterableOnceOps)netClients.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Config.PeerInfo peerInfo = (Config.PeerInfo)tuple2._1();
            ProcessRef ref = (ProcessRef)tuple2._2();
            LeaderElection.Peer peer = LeaderElection.Peer$.MODULE$.builder().id(peerInfo.id()).address(peerInfo.address()).ref(ref).timeoutMs(config.peerTimeout()).build();
            return peer;
        })).toVector()));
    }

    private OParserBuilder<ClusterApp.AppArgs> builder() {
        return builder;
    }

    private OParser<BoxedUnit, ClusterApp.AppArgs> parser() {
        return parser;
    }

    public void onExit() {
        this.zmqContext().close();
    }

    private IO<ClusterApp.AppArgs> parseArgs(String[] args) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            ClusterApp.AppArgs appArgs;
            Predef$.MODULE$.println((Object)System.getProperty("user.dir"));
            Predef$.MODULE$.println((Object)((Object)Paths.get("", new String[0]).toAbsolutePath()).toString());
            Option option = OParser$.MODULE$.parse(MODULE$.parser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new ClusterApp.AppArgs(ClusterApp$AppArgs$.MODULE$.apply$default$1()));
            if (!(option instanceof Some)) {
                throw new IllegalArgumentException("bad program args");
            }
            Some some = (Some)option;
            ClusterApp.AppArgs appArgs2 = appArgs = (ClusterApp.AppArgs)some.value();
            return appArgs2;
        });
    }

    public static final /* synthetic */ void $anonfun$createPeerNetClients$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AsyncClient p = (AsyncClient)tuple2._2();
        MODULE$.eventTransformer(p.ref(), MODULE$.cmdToNetClientSendTransformer());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ClusterApp$() {
    }
}

