/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren.function;

import io.palyvos.haren.Feature;
import io.palyvos.haren.Task;
import io.palyvos.haren.TaskIndexer;
import io.palyvos.haren.function.SingleIntraThreadSchedulingFunction;
import io.palyvos.haren.function.VectorIntraThreadSchedulingFunction;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang3.Validate;

public class VectorIntraThreadSchedulingFunctionImpl
implements VectorIntraThreadSchedulingFunction {
    protected final SingleIntraThreadSchedulingFunction[] functions;
    private final Feature[] requiredFeatures;
    private final String name;
    private boolean caching;

    public VectorIntraThreadSchedulingFunctionImpl(SingleIntraThreadSchedulingFunction ... functions) {
        Validate.notEmpty((Object[])functions, (String)"At least one function is needed!", (Object[])new Object[0]);
        this.functions = functions;
        HashSet<Feature> functionFeatures = new HashSet<Feature>();
        StringBuilder nameBuilder = new StringBuilder("Composite:");
        for (SingleIntraThreadSchedulingFunction function : functions) {
            functionFeatures.addAll(Arrays.asList(function.requiredFeatures()));
            nameBuilder.append(function.name()).append(",");
        }
        this.name = nameBuilder.toString();
        this.requiredFeatures = functionFeatures.toArray(new Feature[0]);
    }

    @Override
    public void apply(Task task, TaskIndexer indexer, double[][] features, double[] output) {
        Validate.isTrue((output.length == this.functions.length ? 1 : 0) != 0);
        for (int k = 0; k < output.length; ++k) {
            output[k] = this.functions[k].apply(task, indexer, features);
        }
    }

    @Override
    public Feature[] requiredFeatures() {
        return this.requiredFeatures;
    }

    @Override
    public VectorIntraThreadSchedulingFunction enableCaching(int nTasks) {
        this.caching = true;
        for (SingleIntraThreadSchedulingFunction function : this.functions) {
            function.enableCaching(nTasks);
        }
        return this;
    }

    @Override
    public void clearCache() {
        for (SingleIntraThreadSchedulingFunction function : this.functions) {
            function.clearCache();
        }
    }

    @Override
    public void reset(int taskCapacity) {
        for (SingleIntraThreadSchedulingFunction function : this.functions) {
            function.reset(taskCapacity);
        }
    }

    @Override
    public boolean cachingEnabled() {
        return this.caching;
    }

    @Override
    public int dimensions() {
        return this.functions.length;
    }

    @Override
    public boolean isReverseOrder(int i) {
        return this.functions[i].isReverseOrder();
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }
}

