/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren.function;

import io.palyvos.haren.Task;
import io.palyvos.haren.TaskIndexer;
import io.palyvos.haren.function.VectorIntraThreadSchedulingFunction;
import java.util.Comparator;
import org.apache.commons.lang3.Validate;

public class VectorIntraThreadSchedulingFunctionComparator
implements Comparator<Task> {
    private final double[][] priorities;
    private final boolean[] reverseOrder;
    private final TaskIndexer indexer;

    public VectorIntraThreadSchedulingFunctionComparator(VectorIntraThreadSchedulingFunction function, double[][] priorities, TaskIndexer indexer) {
        Validate.isTrue((function.dimensions() == priorities[0].length ? 1 : 0) != 0);
        this.priorities = priorities;
        this.indexer = indexer;
        this.reverseOrder = new boolean[function.dimensions()];
        for (int i = 0; i < function.dimensions(); ++i) {
            this.reverseOrder[i] = function.isReverseOrder(i);
        }
    }

    @Override
    public int compare(Task task1, Task task2) {
        double[] p1 = this.priorities[this.indexer.schedulerIndex(task1)];
        double[] p2 = this.priorities[this.indexer.schedulerIndex(task2)];
        for (int k = 0; k < p1.length; ++k) {
            int dimensionComparison = Double.compare(p1[k], p2[k]);
            if (dimensionComparison == 0) continue;
            return this.reverseOrder[k] ? dimensionComparison : -dimensionComparison;
        }
        return 0;
    }
}

