/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren.function;

import io.palyvos.haren.Features;
import io.palyvos.haren.Task;
import io.palyvos.haren.TaskIndexer;
import io.palyvos.haren.function.AbstractIntraThreadSchedulingFunction;
import io.palyvos.haren.function.SingleIntraThreadSchedulingFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CachingIntraThreadSchedulingFunction
extends AbstractIntraThreadSchedulingFunction {
    private static final Logger LOG = LogManager.getLogger();
    private double[] cache;
    private boolean caching;

    public CachingIntraThreadSchedulingFunction(String name, Features ... features) {
        super(name, features);
    }

    public CachingIntraThreadSchedulingFunction(String name, SingleIntraThreadSchedulingFunction ... dependentFunctions) {
        super(name, dependentFunctions);
    }

    protected abstract double applyWithCachingSupport(Task var1, TaskIndexer var2, double[][] var3);

    @Override
    public final double apply(Task task, TaskIndexer indexer, double[][] features) {
        if (this.caching) {
            if (this.cache[indexer.schedulerIndex(task)] < 0.0) {
                double result;
                this.cache[indexer.schedulerIndex((Task)task)] = result = this.applyWithCachingSupport(task, indexer, features);
                return result;
            }
            return this.cache[indexer.schedulerIndex(task)];
        }
        return this.applyWithCachingSupport(task, indexer, features);
    }

    @Override
    public SingleIntraThreadSchedulingFunction enableCaching(int nTasks) {
        LOG.info("Caching enabled for {}", (Object)this.name());
        super.enableCaching(nTasks);
        this.cache = new double[nTasks];
        this.caching = true;
        return this;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        if (this.caching) {
            for (int i = 0; i < this.cache.length; ++i) {
                this.cache[i] = -1.0;
            }
        }
    }

    @Override
    public void reset(int taskCapacity) {
        if (this.caching) {
            this.enableCaching(taskCapacity);
        }
    }

    @Override
    public boolean cachingEnabled() {
        return this.caching;
    }
}

