/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren.function;

import io.palyvos.haren.Feature;
import io.palyvos.haren.Features;
import io.palyvos.haren.function.SingleIntraThreadSchedulingFunction;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang3.Validate;

public abstract class AbstractIntraThreadSchedulingFunction
implements SingleIntraThreadSchedulingFunction {
    protected final SingleIntraThreadSchedulingFunction[] dependentFunctions;
    private final Feature[] requiredFeatures;
    private final String name;
    private boolean caching;

    protected AbstractIntraThreadSchedulingFunction(String name, Features ... requiredFeatures) {
        Validate.notEmpty((Object[])requiredFeatures, (String)"Priority function has no features!", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)name);
        this.requiredFeatures = requiredFeatures;
        this.dependentFunctions = new SingleIntraThreadSchedulingFunction[0];
        this.name = name;
    }

    protected AbstractIntraThreadSchedulingFunction(String name, SingleIntraThreadSchedulingFunction ... dependentFunctions) {
        Validate.notEmpty((CharSequence)name);
        Validate.notEmpty((Object[])dependentFunctions, (String)"Priority function depends on no other function!", (Object[])new Object[0]);
        HashSet<Feature> features = new HashSet<Feature>();
        for (SingleIntraThreadSchedulingFunction function : dependentFunctions) {
            features.addAll(Arrays.asList(function.requiredFeatures()));
        }
        this.requiredFeatures = features.toArray(new Feature[0]);
        this.dependentFunctions = dependentFunctions;
        this.name = name;
    }

    @Override
    public SingleIntraThreadSchedulingFunction enableCaching(int nTasks) {
        this.caching = true;
        for (SingleIntraThreadSchedulingFunction function : this.dependentFunctions) {
            function.enableCaching(nTasks);
        }
        return this;
    }

    @Override
    public void clearCache() {
        for (SingleIntraThreadSchedulingFunction function : this.dependentFunctions) {
            function.clearCache();
        }
    }

    @Override
    public boolean cachingEnabled() {
        return this.caching;
    }

    @Override
    public final Feature[] requiredFeatures() {
        return (Feature[])this.requiredFeatures.clone();
    }

    @Override
    public final String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }
}

