/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren;

import io.palyvos.haren.Feature;
import io.palyvos.haren.Features;
import io.palyvos.haren.ReorderingTaskIndexer;
import io.palyvos.haren.Task;
import io.palyvos.haren.TaskIndexer;
import io.palyvos.haren.function.InterThreadSchedulingFunction;
import io.palyvos.haren.function.IntraThreadSchedulingFunction;
import io.palyvos.haren.function.VectorIntraThreadSchedulingFunction;
import io.palyvos.haren.function.VectorIntraThreadSchedulingFunctionComparator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class SchedulerState {
    private static final Logger LOG = LogManager.getLogger();
    private int taskCapacity;
    private long schedulingPeriod;
    private int batchSize;
    private final boolean priorityCaching;
    private static final Feature[] SCHEDULER_REQUIRED_FEATURES = new Feature[]{Features.COMPONENT_TYPE};
    private final Feature[] constantFeatures;
    private final Feature[] variableFeaturesWithDependencies;
    private final Feature[] variableFeaturesNoDependencies;
    private boolean[] updated;
    private long[] lastUpdateTime;
    double[][] taskFeatures;
    double[][] priorities;
    private final long[] barrierEnter;
    private final long[] barrierExit;
    private VectorIntraThreadSchedulingFunction intraThreadSchedulingFunction;
    private final InterThreadSchedulingFunction interThreadSchedulingFunction;
    private final TaskIndexer indexer;
    Comparator<Task> comparator;
    private long roundEndTime;

    public SchedulerState(int taskCapacity, VectorIntraThreadSchedulingFunction intraThreadSchedulingFunction, InterThreadSchedulingFunction interThreadSchedulingFunction, boolean priorityCaching, int nThreads, long schedulingPeriod, int batchSize) {
        Validate.isTrue((taskCapacity > 0 ? 1 : 0) != 0);
        Validate.isTrue((nThreads > 0 ? 1 : 0) != 0);
        Validate.notNull((Object)intraThreadSchedulingFunction);
        Validate.notNull((Object)interThreadSchedulingFunction);
        this.indexer = new ReorderingTaskIndexer(taskCapacity);
        this.updated = new boolean[taskCapacity];
        this.taskFeatures = new double[taskCapacity][Features.length()];
        this.lastUpdateTime = new long[taskCapacity];
        this.priorities = new double[taskCapacity][intraThreadSchedulingFunction.dimensions()];
        this.barrierEnter = new long[nThreads];
        this.barrierExit = new long[nThreads];
        this.taskCapacity = taskCapacity;
        this.priorityCaching = priorityCaching;
        this.setSchedulingPeriod(schedulingPeriod);
        this.setBatchSize(batchSize);
        this.setIntraThreadSchedulingFunction(intraThreadSchedulingFunction);
        this.interThreadSchedulingFunction = interThreadSchedulingFunction;
        this.constantFeatures = this.getFeatures(intraThreadSchedulingFunction, interThreadSchedulingFunction, feature -> feature.isConstant());
        this.variableFeaturesWithDependencies = this.getFeatures(intraThreadSchedulingFunction, interThreadSchedulingFunction, feature -> !feature.isConstant() && feature.dependencies().length > 0);
        this.variableFeaturesNoDependencies = this.getFeatures(intraThreadSchedulingFunction, interThreadSchedulingFunction, feature -> !feature.isConstant() && feature.dependencies().length == 0);
        LOG.info("Constant Features: {}", (Object)Arrays.toString(this.constantFeatures));
        LOG.info("Variable Features with dependencies: {}", (Object)Arrays.toString(this.variableFeaturesWithDependencies));
        LOG.info("Variable Features without dependencies: {}", (Object)Arrays.toString(this.variableFeaturesNoDependencies));
    }

    private Feature[] getFeatures(IntraThreadSchedulingFunction intraThreadSchedulingFunction, InterThreadSchedulingFunction interThreadSchedulingFunction, Predicate<Feature> predicate) {
        HashSet<Feature> allFeatures = new HashSet<Feature>();
        allFeatures.addAll(Arrays.asList(intraThreadSchedulingFunction.requiredFeatures()));
        allFeatures.addAll(Arrays.asList(interThreadSchedulingFunction.requiredFeatures()));
        allFeatures.addAll(Arrays.asList(SCHEDULER_REQUIRED_FEATURES));
        return (Feature[])allFeatures.stream().filter(predicate).toArray(Feature[]::new);
    }

    private Feature[] getFeatures(IntraThreadSchedulingFunction intraThreadSchedulingFunction, InterThreadSchedulingFunction interThreadSchedulingFunction) {
        return this.getFeatures(intraThreadSchedulingFunction, interThreadSchedulingFunction, feature -> true);
    }

    void markUpdated(Task task) {
        this.updated[this.indexer.schedulerIndex((Task)task)] = true;
    }

    void markRun(Task task, long timestamp) {
        this.lastUpdateTime[this.indexer.schedulerIndex((Task)task)] = timestamp;
        this.updated[this.indexer.schedulerIndex((Task)task)] = true;
    }

    boolean resetUpdated(Task task) {
        boolean state = this.updated[this.indexer.schedulerIndex(task)];
        this.updated[this.indexer.schedulerIndex((Task)task)] = false;
        return state;
    }

    boolean timeToUpdate(Task task, long timestamp, long updateLimitMillis) {
        return timestamp - this.lastUpdateTime[this.indexer.schedulerIndex(task)] > updateLimitMillis;
    }

    Feature[] constantFeatures() {
        return this.constantFeatures;
    }

    Feature[] variableFeaturesWithDependencies() {
        return this.variableFeaturesWithDependencies;
    }

    Feature[] variableFeaturesNoDependencies() {
        return this.variableFeaturesNoDependencies;
    }

    VectorIntraThreadSchedulingFunction intraThreadSchedulingFunction() {
        return this.intraThreadSchedulingFunction;
    }

    InterThreadSchedulingFunction interThreadSchedulingFunction() {
        return this.interThreadSchedulingFunction;
    }

    void updateRoundEndTime() {
        this.roundEndTime = System.currentTimeMillis() + this.schedulingPeriod;
    }

    long remainingRoundTime() {
        return this.roundEndTime - System.currentTimeMillis();
    }

    void recordBarrierEnter(int executorIndex, long duration) {
        this.barrierEnter[executorIndex] = duration;
    }

    void recordBarrierExit(int executorIndex, long duration) {
        this.barrierExit[executorIndex] = duration;
    }

    long barrierEnterVariance() {
        return this.variance(this.barrierEnter);
    }

    long barrierExitVariance() {
        return this.variance(this.barrierExit);
    }

    private long variance(long[] data) {
        long min = data[0];
        long max = data[0];
        for (long d : data) {
            min = Math.min(d, min);
            max = Math.max(d, max);
        }
        return max - min;
    }

    long schedulingPeriod() {
        return this.schedulingPeriod;
    }

    void setSchedulingPeriod(long schedulingPeriod) {
        Validate.isTrue((schedulingPeriod > 0L ? 1 : 0) != 0);
        this.schedulingPeriod = schedulingPeriod;
    }

    int batchSize() {
        return this.batchSize;
    }

    void setBatchSize(int batchSize) {
        Validate.isTrue((batchSize > 0 ? 1 : 0) != 0);
        this.batchSize = batchSize;
    }

    void resetSchedulingFunctions(List<Task> tasks) {
        this.interThreadSchedulingFunction().reset(tasks, this.taskCapacity, this.indexer, this.taskFeatures);
        this.intraThreadSchedulingFunction().reset(this.taskCapacity);
        this.resetIntraThreadPriorityComparator();
    }

    void setIntraThreadSchedulingFunction(VectorIntraThreadSchedulingFunction intraThreadSchedulingFunction) {
        this.intraThreadSchedulingFunction = this.priorityCaching && !intraThreadSchedulingFunction.cachingEnabled() ? intraThreadSchedulingFunction.enableCaching(this.taskCapacity) : intraThreadSchedulingFunction;
        this.resetIntraThreadPriorityComparator();
    }

    void resetIntraThreadPriorityComparator() {
        this.comparator = new VectorIntraThreadSchedulingFunctionComparator(this.intraThreadSchedulingFunction, this.priorities, this.indexer);
    }

    TaskIndexer indexer() {
        return this.indexer;
    }

    void unregisterTasks(List<Task> tasksToRemove) {
        for (Task task : tasksToRemove) {
            this.clearTaskState(task);
        }
        this.indexer.unregisterTasks(tasksToRemove);
    }

    private void clearTaskState(Task task) {
        LOG.debug("Clearing state for removed task {}", (Object)task);
        int taskIndex = this.indexer.schedulerIndex(task);
        this.updated[taskIndex] = false;
        double[] featureVector = this.taskFeatures[taskIndex];
        for (int i = 0; i < featureVector.length; ++i) {
            featureVector[i] = 0.0;
        }
        double[] priorityVector = this.priorities[taskIndex];
        for (int i = 0; i < priorityVector.length; ++i) {
            priorityVector[i] = 0.0;
        }
        this.lastUpdateTime[taskIndex] = 0L;
    }

    public void registerTasks(List<Task> tasksToAdd) {
        this.indexer.registerTasks(tasksToAdd);
        int newNumberOfTasks = this.indexer.indexedTasks();
        if (newNumberOfTasks > this.taskCapacity) {
            this.resizeTaskState(newNumberOfTasks);
            this.taskCapacity = newNumberOfTasks;
        }
    }

    private void resizeTaskState(int newNumberOfTasks) {
        LOG.info("Resizing task state from {} to {}...", (Object)this.taskCapacity, (Object)newNumberOfTasks);
        boolean[] newUpdated = new boolean[newNumberOfTasks];
        System.arraycopy(this.updated, 0, newUpdated, 0, this.updated.length);
        this.updated = newUpdated;
        long[] newLastUpdateTime = new long[newNumberOfTasks];
        System.arraycopy(this.lastUpdateTime, 0, newLastUpdateTime, 0, this.lastUpdateTime.length);
        this.lastUpdateTime = newLastUpdateTime;
        this.taskFeatures = this.enlarge2DArray(this.taskFeatures, newNumberOfTasks, Features.length());
        this.priorities = this.enlarge2DArray(this.priorities, newNumberOfTasks, this.intraThreadSchedulingFunction.dimensions());
    }

    private double[][] enlarge2DArray(double[][] source, int destRows, int destCols) {
        int rows = source.length;
        int cols = source[0].length;
        Validate.isTrue((destRows >= rows ? 1 : 0) != 0);
        Validate.isTrue((destCols >= cols ? 1 : 0) != 0);
        double[][] dest = new double[destRows][destCols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(source[i], 0, dest[i], 0, cols);
        }
        return dest;
    }
}

