/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren;

import java.util.Random;
import org.apache.commons.lang3.Validate;

class SchedulerBackoff {
    private final long min;
    private final long max;
    private final int retries;
    private final Random rand = new Random();
    private long currentLimit;
    private long currentRetries;

    public SchedulerBackoff(long min, long max, int retries) {
        this.min = Math.max(min, 1L);
        this.max = Math.max(max, 1L);
        Validate.isTrue((this.min > 0L ? 1 : 0) != 0);
        Validate.isTrue((this.min <= this.max ? 1 : 0) != 0);
        this.retries = retries;
        this.currentLimit = min;
        this.currentRetries = retries;
    }

    public void backoff(long maxDelayMillis) {
        long sleepTime;
        long delay = this.rand.nextLong() % this.currentLimit;
        --this.currentRetries;
        if (this.currentRetries == 0L) {
            this.currentLimit = Math.min(2L * this.currentLimit, this.max);
            this.currentRetries = this.retries;
        }
        if ((sleepTime = Math.min(delay, maxDelayMillis)) > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public void relax() {
        if (this.currentRetries < (long)this.retries) {
            ++this.currentRetries;
            if (this.currentRetries == (long)this.retries) {
                this.currentLimit = Math.max(this.currentLimit / 2L, this.min);
            }
        }
    }

    public void reset() {
        this.currentLimit = this.min;
        this.currentRetries = this.retries;
    }
}

