/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren;

import io.palyvos.haren.Task;
import io.palyvos.haren.TaskIndexer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ReorderingTaskIndexer
implements TaskIndexer {
    private final Map<Integer, Integer> taskIndexes = new HashMap<Integer, Integer>();
    private final Set<Integer> freeIndexes = new HashSet<Integer>();
    private int indexedTasksNumber;

    ReorderingTaskIndexer(int indexedTasksNumber) {
        this.indexedTasksNumber = indexedTasksNumber;
    }

    @Override
    public int schedulerIndex(Task task) {
        if (this.taskIndexes.isEmpty()) {
            return task.getIndex();
        }
        Integer mappedIndex = this.taskIndexes.get(task.getIndex());
        return mappedIndex != null ? mappedIndex.intValue() : task.getIndex();
    }

    @Override
    public synchronized void registerTasks(Collection<Task> tasks) {
        int neededIndexes = tasks.size() - this.freeIndexes.size();
        for (int i = this.indexedTasksNumber; i < this.indexedTasksNumber + neededIndexes; ++i) {
            this.freeIndexes.add(i);
        }
        for (Task task : tasks) {
            this.registerTask(task);
        }
    }

    private synchronized void registerTask(Task task) {
        ++this.indexedTasksNumber;
        boolean taskIndexIsFree = this.freeIndexes.remove(task.getIndex());
        if (taskIndexIsFree) {
            return;
        }
        if (this.freeIndexes.isEmpty()) {
            this.taskIndexes.put(this.indexedTasksNumber - 1, task.getIndex());
        } else {
            Iterator<Integer> freeIndexIterator = this.freeIndexes.iterator();
            int reorderIndex = freeIndexIterator.next();
            this.taskIndexes.put(task.getIndex(), reorderIndex);
            freeIndexIterator.remove();
        }
    }

    @Override
    public synchronized void unregisterTasks(Collection<Task> tasks) {
        for (Task task : tasks) {
            this.unregisterTask(task);
        }
    }

    @Override
    public int indexedTasks() {
        return this.indexedTasksNumber;
    }

    private synchronized void unregisterTask(Task task) {
        Integer reorderIndex = this.taskIndexes.remove(task.getIndex());
        int schedulerIndex = Optional.ofNullable(reorderIndex).orElse(task.getIndex());
        this.freeIndexes.add(schedulerIndex);
        --this.indexedTasksNumber;
    }
}

