/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren;

import io.palyvos.haren.AbstractExecutor;
import io.palyvos.haren.HarenScheduler;
import io.palyvos.haren.SchedulerState;
import io.palyvos.haren.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ReconfigurationAction
implements Runnable {
    private static final Logger LOG = LogManager.getLogger();
    private final List<Task> tasks;
    private final List<AbstractExecutor> executors;
    private final SchedulerState state;
    private boolean firstUpdate = true;
    private List<Task> tasksToAdd = new ArrayList<Task>();
    private List<Task> tasksToRemove = new ArrayList<Task>();
    private final Set<Integer> taskIndexes = new HashSet<Integer>();

    public ReconfigurationAction(List<Task> inputTasks, List<AbstractExecutor> executors, SchedulerState state) {
        this.tasks = new ArrayList<Task>(inputTasks);
        Collections.sort(this.tasks, Comparator.comparingInt(Task::getIndex));
        this.taskIndexes.addAll(HarenScheduler.taskIndexes(this.tasks));
        this.executors = executors;
        this.state = state;
        this.state.resetSchedulingFunctions(this.tasks);
    }

    @Override
    public void run() {
        Validate.isTrue((this.tasks.size() > 0 ? 1 : 0) != 0, (String)"No tasks given!", (Object[])new Object[0]);
        boolean configurationChanged = this.addRemoveTasks();
        if (this.firstUpdate || configurationChanged) {
            this.updateAllFeatures();
            this.firstUpdate = false;
        } else {
            this.updateFeaturesWithDependencies();
        }
        this.state.intraThreadSchedulingFunction().clearCache();
        List<List<Task>> assignments = this.deployTasks();
        this.assignTasks(assignments);
        this.state.updateRoundEndTime();
    }

    private void updateFeaturesWithDependencies() {
        long startTime = System.currentTimeMillis();
        for (Task task : this.tasks) {
            if (!this.state.resetUpdated(task)) continue;
            task.updateFeatures(this.state.variableFeaturesWithDependencies(), this.state.taskFeatures[this.state.indexer().schedulerIndex(task)]);
        }
    }

    private void updateAllFeatures() {
        long startTime = System.currentTimeMillis();
        for (Task task : this.tasks) {
            task.refreshFeatures();
            task.updateFeatures(this.state.constantFeatures(), this.state.taskFeatures[this.state.indexer().schedulerIndex(task)]);
            task.updateFeatures(this.state.variableFeaturesNoDependencies(), this.state.taskFeatures[this.state.indexer().schedulerIndex(task)]);
            task.updateFeatures(this.state.variableFeaturesWithDependencies(), this.state.taskFeatures[this.state.indexer().schedulerIndex(task)]);
        }
    }

    private List<List<Task>> deployTasks() {
        long startTime = System.currentTimeMillis();
        List<List<Task>> assignments = this.state.interThreadSchedulingFunction().getAssignment(this.executors.size());
        return assignments;
    }

    private void assignTasks(List<List<Task>> assignments) {
        Validate.isTrue((assignments.size() <= this.executors.size() ? 1 : 0) != 0, (String)"#assignments > #threads", (Object[])new Object[0]);
        int taskCount = 0;
        for (int threadId = 0; threadId < this.executors.size(); ++threadId) {
            List<Task> assignment = threadId < assignments.size() ? assignments.get(threadId) : Collections.emptyList();
            this.executors.get(threadId).setTasks(assignment);
            taskCount += assignment.size();
        }
        Validate.isTrue((taskCount == this.tasks.size() ? 1 : 0) != 0, (String)"It seems that the inter-thread function did not assign each task to exactly one executor!", (Object[])new Object[0]);
    }

    void stop() {
    }

    private synchronized boolean addRemoveTasks() {
        boolean configurationChanged = false;
        if (!this.tasksToRemove.isEmpty()) {
            this.validateTaskRemoval();
            LOG.info("Unregistering tasks: {}", this.tasksToRemove);
            this.state.unregisterTasks(this.tasksToRemove);
            configurationChanged = true;
        }
        if (!this.tasksToAdd.isEmpty()) {
            this.validateTaskAddition();
            LOG.info("Registering tasks: {}", this.tasksToAdd);
            this.state.registerTasks(this.tasksToAdd);
            configurationChanged = true;
        }
        if (configurationChanged) {
            this.tasks.removeAll(this.tasksToRemove);
            this.taskIndexes.removeAll(HarenScheduler.taskIndexes(this.tasksToRemove));
            LOG.debug("Removed tasks: {}", this.tasksToRemove);
            this.tasks.addAll(this.tasksToAdd);
            this.taskIndexes.addAll(HarenScheduler.taskIndexes(this.tasksToAdd));
            LOG.debug("Added tasks: {}", this.tasksToAdd);
            this.tasksToRemove.clear();
            this.tasksToAdd.clear();
            this.state.resetSchedulingFunctions(this.tasks);
            LOG.debug("Reconfiguration complete.");
        }
        return configurationChanged;
    }

    private void validateTaskAddition() {
        for (Task task : this.tasksToAdd) {
            if (!this.taskIndexes.contains(task.getIndex())) continue;
            throw new IllegalArgumentException(String.format("Tried to add task %s which is already being scheduled!", task.toString()));
        }
    }

    private void validateTaskRemoval() {
        for (Task task : this.tasksToRemove) {
            if (this.taskIndexes.contains(task.getIndex())) continue;
            throw new IllegalArgumentException(String.format("Tried to remove task %s which is not being scheduled!", task.toString()));
        }
    }

    synchronized void addTasks(Collection<Task> tasks) {
        this.tasksToAdd.addAll(tasks);
    }

    synchronized void removeTasks(Collection<Task> tasks) {
        this.tasksToRemove.addAll(tasks);
    }
}

