/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren;

import io.palyvos.haren.Task;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryResolver {
    private static final Logger LOG = LogManager.getLogger();
    private final Map<Integer, List<Task>> queryToTasks = new HashMap<Integer, List<Task>>();
    private final Map<Integer, Integer> taskToQuery = new HashMap<Integer, Integer>();
    private int nQueries;

    public QueryResolver(List<Task> tasks) {
        this.resolveQueries(tasks);
    }

    public Collection<List<Task>> getQueries() {
        return this.queryToTasks.values();
    }

    private void resolveQueries(List<Task> tasks) {
        for (Task task : tasks) {
            this.traverseTaskGraph(task);
        }
        LOG.info("{} queries found", (Object)this.nQueries);
        Iterator<Object> iterator = this.queryToTasks.keySet().iterator();
        while (iterator.hasNext()) {
            int queryNumber = (Integer)iterator.next();
            LOG.debug("Query #{} -> {}", (Object)queryNumber, this.queryToTasks.get(queryNumber));
        }
    }

    private void traverseTaskGraph(Task task) {
        if (this.getOrZero(this.taskToQuery, task.getIndex()) > 0) {
            return;
        }
        ++this.nQueries;
        ArrayDeque<Task> q = new ArrayDeque<Task>();
        q.addLast(task);
        this.queryToTasks.put(this.nQueries, new ArrayList());
        while (!q.isEmpty()) {
            Task current = (Task)q.removeFirst();
            int currentIndex = current.getIndex();
            if (this.getOrZero(this.taskToQuery, currentIndex) != 0) continue;
            this.queryToTasks.get(this.nQueries).add(current);
            this.taskToQuery.put(currentIndex, this.nQueries);
            current.getDownstream().forEach(t -> q.addLast((Task)t));
            current.getUpstream().forEach(t -> q.addLast((Task)t));
        }
    }

    private int getOrZero(Map<Integer, Integer> map, int key) {
        Integer value = map.get(key);
        return value != null ? value : 0;
    }
}

