/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren;

import io.palyvos.haren.AbstractExecutor;
import io.palyvos.haren.SchedulerState;
import io.palyvos.haren.Task;
import java.util.concurrent.CyclicBarrier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class HighestPriorityExecutor
extends AbstractExecutor {
    private static final Logger LOG = LogManager.getLogger();
    private int localIndex;
    private boolean equalPhase;
    private boolean[] isNextEqual;

    public HighestPriorityExecutor(int batchSize, int schedulingPeriodMillis, CyclicBarrier barrier, SchedulerState state) {
        super(state, barrier);
    }

    public HighestPriorityExecutor(SchedulerState state, CyclicBarrier barrier, int cpuId) {
        super(state, cpuId, barrier);
    }

    @Override
    protected boolean runNextTask() {
        boolean didRun = false;
        while (this.localIndex < this.executorTasks.size()) {
            Task task;
            if (this.finishedEqualPhase()) {
                this.resetEqualPhase();
            }
            if ((task = (Task)this.executorTasks.get(this.localIndex)).canRun() && task.runFor(this.state.batchSize())) {
                this.mark(task, this.localIndex);
                didRun = true;
                break;
            }
            ++this.localIndex;
        }
        if (didRun && this.isNextEqual[this.localIndex]) {
            this.enterEqualPhase();
        } else {
            this.resetEqualPhase();
        }
        return didRun;
    }

    @Override
    protected void onRoundStart() {
        this.markEqualPriorities();
        this.resetEqualPhase();
    }

    protected void markEqualPriorities() {
        this.isNextEqual = new boolean[this.executorTasks.size()];
        for (int i = 0; i < this.executorTasks.size() - 1; ++i) {
            Task next;
            Task current = (Task)this.executorTasks.get(i);
            if (this.state.comparator.compare(current, next = (Task)this.executorTasks.get(i + 1)) != 0) continue;
            this.isNextEqual[i] = true;
        }
    }

    private void resetEqualPhase() {
        this.localIndex = 0;
        this.equalPhase = false;
    }

    private void enterEqualPhase() {
        this.equalPhase = true;
        ++this.localIndex;
    }

    private boolean finishedEqualPhase() {
        return this.equalPhase && !this.isNextEqual[this.localIndex - 1];
    }
}

