/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren;

import io.palyvos.haren.Feature;
import io.palyvos.haren.FeatureDependency;
import io.palyvos.haren.Task;
import io.palyvos.haren.TaskDependency;
import io.palyvos.haren.TaskIndexer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum Features implements Feature
{
    TOPOLOGICAL_ORDER(0, true),
    SELECTIVITY(1, false),
    COST(2, false),
    HEAD_ARRIVAL_TIME(3, false),
    AVERAGE_ARRIVAL_TIME(4, false),
    COMPONENT_TYPE(5, true),
    RATE(6, false),
    USER_PRIORITY(7, true),
    INPUT_QUEUE_SIZE(8, false),
    OUTPUT_QUEUE_SIZE(9, false);

    public static final Map<Feature, FeatureDependency[]> dependencies;
    private static final FeatureDependency[] NO_DEPENDENCIES;
    private final int index;
    private final boolean constant;

    private Features(int index, boolean constant) {
        this.index = index;
        this.constant = constant;
    }

    public static int length() {
        return Features.values().length;
    }

    public static double[] createArray() {
        return new double[Features.length()];
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public double get(Task task, TaskIndexer indexer, double[][] features) {
        return features[indexer.schedulerIndex(task)][this.index];
    }

    @Override
    public FeatureDependency[] dependencies() {
        return dependencies.getOrDefault(this, NO_DEPENDENCIES);
    }

    static {
        NO_DEPENDENCIES = new FeatureDependency[0];
        HashMap<Features, FeatureDependency[]> deps = new HashMap<Features, FeatureDependency[]>();
        deps.put(HEAD_ARRIVAL_TIME, new FeatureDependency[]{FeatureDependency.of(HEAD_ARRIVAL_TIME), FeatureDependency.of(AVERAGE_ARRIVAL_TIME)});
        deps.put(AVERAGE_ARRIVAL_TIME, new FeatureDependency[]{FeatureDependency.of(HEAD_ARRIVAL_TIME), FeatureDependency.of(AVERAGE_ARRIVAL_TIME)});
        deps.put(INPUT_QUEUE_SIZE, new FeatureDependency[]{FeatureDependency.of(INPUT_QUEUE_SIZE, TaskDependency.DOWNSTREAM)});
        deps.put(OUTPUT_QUEUE_SIZE, new FeatureDependency[]{FeatureDependency.of(INPUT_QUEUE_SIZE, TaskDependency.DOWNSTREAM)});
        dependencies = Collections.unmodifiableMap(deps);
    }
}

