/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren;

import io.palyvos.haren.Features;

public final class FeatureHelper {
    public static final double NO_ARRIVAL_TIME = Double.MAX_VALUE;
    public static final long MAX_QUEUE_SIZE = 10000L;
    public static int CTYPE_SOURCE = 0;
    public static int CTYPE_SINK = 1;
    public static int CTYPE_OPERATOR = 2;
    public static int CTYPE_ROUTER = 3;
    public static int CTYPE_UNION = 4;
    public static int CTYPE_JOIN = 5;

    private FeatureHelper() {
    }

    public static double getLatency(double arrivalTime, long currentTime) {
        return arrivalTime < 0.0 ? 0.0 : (double)currentTime - arrivalTime;
    }

    public static double getHeadLatency(double[] features, long currentTime) {
        return FeatureHelper.getLatency(features[Features.HEAD_ARRIVAL_TIME.index()], currentTime);
    }

    public static double getAverageLatency(double[] features, long currentTime) {
        return FeatureHelper.getLatency(features[Features.AVERAGE_ARRIVAL_TIME.index()], currentTime);
    }

    public static boolean noArrivalTime(double arrivalTime) {
        return arrivalTime < 0.0;
    }

    public static boolean noArrivalTime(long arrivalTime) {
        return arrivalTime < 0L;
    }
}

