/*
 * Decompiled with CFR 0.152.
 */
package io.palyvos.haren;

import io.palyvos.haren.Feature;
import io.palyvos.haren.FeatureDependency;
import io.palyvos.haren.SchedulerBackoff;
import io.palyvos.haren.SchedulerState;
import io.palyvos.haren.Task;
import io.palyvos.haren.TaskDependency;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.affinity.Affinity;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractExecutor
implements Runnable {
    private static final int BACKOFF_MIN_MILLIS = 1;
    private static final AtomicInteger indexGenerator = new AtomicInteger();
    private static final Logger LOG = LogManager.getLogger();
    private static final int BACKOFF_RETRIES = 3;
    private static final int TASK_UPDATE_LIMIT_FACTOR = 2;
    protected final CyclicBarrier barrier;
    protected final SchedulerState state;
    private final int index;
    private final Set<Integer> runTasks = new HashSet<Integer>();
    private final Set<TaskDependency> taskDependencies = new HashSet<TaskDependency>();
    private final SchedulerBackoff backoff;
    private final int cpuId;
    protected volatile List<Task> executorTasks = Collections.emptyList();

    public AbstractExecutor(SchedulerState state, CyclicBarrier barrier) {
        this(state, -1, barrier);
    }

    public AbstractExecutor(SchedulerState state, int cpuId, CyclicBarrier barrier) {
        this.barrier = barrier;
        this.state = state;
        this.backoff = new SchedulerBackoff(1L, state.schedulingPeriod() / 10L, 3);
        this.index = indexGenerator.getAndIncrement();
        this.cpuId = cpuId;
        this.initTaskDependencies(state.variableFeaturesWithDependencies());
    }

    private void initTaskDependencies(Feature[] features) {
        for (Feature feature : features) {
            for (FeatureDependency dependency : feature.dependencies()) {
                this.taskDependencies.addAll(Arrays.asList(dependency.dependencies));
            }
        }
    }

    public void setTasks(List<Task> tasks) {
        this.executorTasks = tasks;
    }

    @Override
    public void run() {
        if (this.cpuId > 0) {
            LOG.info("Setting affinity to CPU #{}", (Object)this.cpuId);
            Affinity.setAffinity((int)this.cpuId);
        }
        if (!this.updateTasks()) {
            return;
        }
        this.beginRound();
        while (!Thread.currentThread().isInterrupted()) {
            boolean didRun = this.runNextTask();
            this.adjustUtilization(didRun, this.state.remainingRoundTime());
            if (this.state.remainingRoundTime() > 0L) continue;
            if (!this.updateTasks()) break;
            this.beginRound();
        }
        LOG.debug("Executor {} finished.", (Object)this.index);
    }

    private void beginRound() {
        this.calculatePriorities();
        this.sortTasks();
        this.onRoundStart();
        this.runLaggingTasks();
        this.backoff.reset();
        if (LOG.getLevel() == Level.TRACE) {
            this.printTasks();
        }
    }

    private void calculatePriorities() {
        for (Task task : this.executorTasks) {
            this.state.intraThreadSchedulingFunction().apply(task, this.state.indexer(), this.state.taskFeatures, this.state.priorities[this.state.indexer().schedulerIndex(task)]);
        }
    }

    private void runLaggingTasks() {
        long timestamp = System.currentTimeMillis();
        for (int i = 0; i < this.executorTasks.size(); ++i) {
            Task task = this.executorTasks.get(i);
            if (!this.state.timeToUpdate(task, timestamp, 2L * this.state.schedulingPeriod())) continue;
            task.runFor(1);
            this.mark(task, i);
        }
    }

    private void adjustUtilization(boolean didRun, long remainingTime) {
        if (remainingTime <= 0L) {
            return;
        }
        if (!didRun) {
            this.backoff.backoff(remainingTime);
            return;
        }
        this.backoff.relax();
    }

    private boolean updateTasks() {
        try {
            this.markUpdated();
            long barrierEnterTime = System.currentTimeMillis();
            this.state.recordBarrierEnter(this.index, barrierEnterTime);
            this.barrier.await();
            long barrierExitTime = System.currentTimeMillis();
            this.state.recordBarrierExit(this.index, barrierExitTime);
            return true;
        }
        catch (InterruptedException | BrokenBarrierException e) {
            return false;
        }
    }

    private void sortTasks() {
        this.executorTasks.sort(this.state.comparator);
    }

    private void markUpdated() {
        long markTime = System.currentTimeMillis();
        for (Task task : this.executorTasks) {
            task.refreshFeatures();
        }
        Iterator<Object> iterator = this.runTasks.iterator();
        while (iterator.hasNext()) {
            int taskIndex = (Integer)iterator.next();
            Task task = this.executorTasks.get(taskIndex);
            task.updateFeatures(this.state.variableFeaturesNoDependencies(), this.state.taskFeatures[this.state.indexer().schedulerIndex(task)]);
            this.state.markRun(task, markTime);
            for (TaskDependency taskDependency : this.taskDependencies) {
                for (Task task2 : taskDependency.dependents(task)) {
                    this.state.markUpdated(task2);
                }
            }
        }
        this.runTasks.clear();
    }

    protected final void mark(Task task, int localIndex) {
        this.runTasks.add(localIndex);
    }

    protected abstract boolean runNextTask();

    protected abstract void onRoundStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void printTasks() {
        Class<AbstractExecutor> clazz = AbstractExecutor.class;
        synchronized (AbstractExecutor.class) {
            LOG.info("-----Thread assignment-----");
            for (Task task : this.executorTasks) {
                LOG.info("[{}, {}] -> {}", (Object)task, (Object)Arrays.toString(this.state.priorities[this.state.indexer().schedulerIndex(task)]), (Object)Arrays.toString(this.state.taskFeatures[this.state.indexer().schedulerIndex(task)]));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return "EXECUTOR: " + this.executorTasks + "\n";
    }
}

