/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.limit;

import com.netflix.conductor.annotations.Trace;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.core.exception.ApplicationException;
import com.netflix.conductor.dao.ConcurrentExecutionLimitDAO;
import com.netflix.conductor.metrics.Monitors;
import com.netflix.conductor.model.TaskModel;
import com.netflix.conductor.redis.limit.config.RedisConcurrentExecutionLimitProperties;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Trace
@Component
@ConditionalOnProperty(value={"conductor.redis-concurrent-execution-limit.enabled"}, havingValue="true")
public class RedisConcurrentExecutionLimitDAO
implements ConcurrentExecutionLimitDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisConcurrentExecutionLimitDAO.class);
    private static final String CLASS_NAME = RedisConcurrentExecutionLimitDAO.class.getSimpleName();
    private final StringRedisTemplate stringRedisTemplate;
    private final RedisConcurrentExecutionLimitProperties properties;

    public RedisConcurrentExecutionLimitDAO(StringRedisTemplate stringRedisTemplate, RedisConcurrentExecutionLimitProperties properties) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.properties = properties;
    }

    public void addTaskToLimit(TaskModel task) {
        try {
            Monitors.recordDaoRequests((String)CLASS_NAME, (String)"addTaskToLimit", (String)task.getTaskType(), (String)task.getWorkflowType());
            String taskId = task.getTaskId();
            String taskDefName = task.getTaskDefName();
            String keyName = this.createKeyName(taskDefName);
            this.stringRedisTemplate.opsForSet().add((Object)keyName, (Object[])new String[]{taskId});
            LOGGER.debug("Added taskId: {} to key: {}", (Object)taskId, (Object)keyName);
        }
        catch (Exception e) {
            Monitors.error((String)CLASS_NAME, (String)"addTaskToLimit");
            String errorMsg = String.format("Error updating taskDefLimit for task - %s:%s in workflow: %s", task.getTaskDefName(), task.getTaskId(), task.getWorkflowInstanceId());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, errorMsg, (Throwable)e);
        }
    }

    public void removeTaskFromLimit(TaskModel task) {
        try {
            Monitors.recordDaoRequests((String)CLASS_NAME, (String)"removeTaskFromLimit", (String)task.getTaskType(), (String)task.getWorkflowType());
            String taskId = task.getTaskId();
            String taskDefName = task.getTaskDefName();
            String keyName = this.createKeyName(taskDefName);
            this.stringRedisTemplate.opsForSet().remove((Object)keyName, new Object[]{taskId});
            LOGGER.debug("Removed taskId: {} from key: {}", (Object)taskId, (Object)keyName);
        }
        catch (Exception e) {
            Monitors.error((String)CLASS_NAME, (String)"removeTaskFromLimit");
            String errorMsg = String.format("Error updating taskDefLimit for task - %s:%s in workflow: %s", task.getTaskDefName(), task.getTaskId(), task.getWorkflowInstanceId());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, errorMsg, (Throwable)e);
        }
    }

    public boolean exceedsLimit(TaskModel task) {
        Optional taskDefinition = task.getTaskDefinition();
        if (taskDefinition.isEmpty()) {
            return false;
        }
        int limit = ((TaskDef)taskDefinition.get()).concurrencyLimit();
        if (limit <= 0) {
            return false;
        }
        try {
            Monitors.recordDaoRequests((String)CLASS_NAME, (String)"exceedsLimit", (String)task.getTaskType(), (String)task.getWorkflowType());
            String taskId = task.getTaskId();
            String taskDefName = task.getTaskDefName();
            String keyName = this.createKeyName(taskDefName);
            boolean isMember = (Boolean)ObjectUtils.defaultIfNull((Object)this.stringRedisTemplate.opsForSet().isMember((Object)keyName, (Object)taskId), (Object)false);
            long size = (Long)ObjectUtils.defaultIfNull((Object)this.stringRedisTemplate.opsForSet().size((Object)keyName), (Object)-1L);
            LOGGER.debug("Task: {} is {} of {}, size: {} and limit: {}", new Object[]{taskId, isMember ? "a member" : "not a member", keyName, size, limit});
            return !isMember && size >= (long)limit;
        }
        catch (Exception e) {
            Monitors.error((String)CLASS_NAME, (String)"exceedsLimit");
            String errorMsg = String.format("Failed to get in progress limit - %s:%s in workflow :%s", task.getTaskDefName(), task.getTaskId(), task.getWorkflowInstanceId());
            LOGGER.error(errorMsg, (Throwable)e);
            throw new ApplicationException(ApplicationException.Code.BACKEND_ERROR, errorMsg);
        }
    }

    private String createKeyName(String taskDefName) {
        StringBuilder builder = new StringBuilder();
        String namespace = this.properties.getNamespace();
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            builder.append(namespace).append(':');
        }
        return builder.append(taskDefName).toString();
    }
}

