/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.errorprone.annotations.Immutable;

@Immutable
public class JavaFormatterOptions {
    private final Style style;
    private final boolean formatJavadoc;

    private JavaFormatterOptions(Style style, boolean formatJavadoc) {
        this.style = style;
        this.formatJavadoc = formatJavadoc;
    }

    public int indentationMultiplier() {
        return this.style.indentationMultiplier();
    }

    public boolean formatJavadoc() {
        return this.formatJavadoc;
    }

    public Style style() {
        return this.style;
    }

    public static JavaFormatterOptions defaultOptions() {
        return JavaFormatterOptions.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Style style = Style.GOOGLE;
        private boolean formatJavadoc = true;

        private Builder() {
        }

        public Builder style(Style style) {
            this.style = style;
            return this;
        }

        public Builder formatJavadoc(boolean formatJavadoc) {
            this.formatJavadoc = formatJavadoc;
            return this;
        }

        public JavaFormatterOptions build() {
            return new JavaFormatterOptions(this.style, this.formatJavadoc);
        }
    }

    public static enum Style {
        GOOGLE(1),
        AOSP(2);

        private final int indentationMultiplier;

        private Style(int indentationMultiplier) {
            this.indentationMultiplier = indentationMultiplier;
        }

        int indentationMultiplier() {
            return this.indentationMultiplier;
        }
    }
}

