/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.Objects;

public final class Replacement {
    private final Range<Integer> replaceRange;
    private final String replacementString;

    public static Replacement create(int startPosition, int endPosition, String replaceWith) {
        Preconditions.checkArgument(startPosition >= 0, "startPosition must be non-negative");
        Preconditions.checkArgument(startPosition <= endPosition, "startPosition cannot be after endPosition");
        return new Replacement(Range.closedOpen(startPosition, endPosition), replaceWith);
    }

    private Replacement(Range<Integer> replaceRange, String replacementString) {
        this.replaceRange = Preconditions.checkNotNull(replaceRange, "Null replaceRange");
        this.replacementString = Preconditions.checkNotNull(replacementString, "Null replacementString");
    }

    public Range<Integer> getReplaceRange() {
        return this.replaceRange;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Replacement) {
            Replacement that = (Replacement)o;
            return this.replaceRange.equals(that.getReplaceRange()) && this.replacementString.equals(that.getReplacementString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.replaceRange, this.replacementString);
    }
}

