/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.util;

import io.opentracing.NoopTracer;
import io.opentracing.NoopTracerFactory;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GlobalTracer
implements Tracer {
    private static final Logger LOGGER = Logger.getLogger(GlobalTracer.class.getName());
    private static final GlobalTracer INSTANCE = new GlobalTracer();
    private static Tracer tracer = NoopTracerFactory.create();

    private GlobalTracer() {
    }

    public static Tracer get() {
        return INSTANCE;
    }

    public static synchronized void register(Tracer tracer) {
        if (tracer == null) {
            throw new NullPointerException("Cannot register GlobalTracer <null>.");
        }
        if (tracer instanceof GlobalTracer) {
            LOGGER.log(Level.FINE, "Attempted to register the GlobalTracer as delegate of itself.");
            return;
        }
        if (GlobalTracer.tracer instanceof NoopTracer) {
            GlobalTracer.tracer = tracer;
        } else if (!GlobalTracer.tracer.equals(tracer)) {
            throw new IllegalStateException("There is already a current global Tracer registered.");
        }
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return tracer.buildSpan(operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        tracer.inject(spanContext, format, carrier);
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        return tracer.extract(format, carrier);
    }

    public String toString() {
        return GlobalTracer.class.getSimpleName() + '{' + tracer + '}';
    }
}

