/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opencensusshim;

import io.opencensus.common.Function;
import io.opencensus.trace.BlankSpan;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import io.opencensus.trace.Tracestate;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.TraceStateBuilder;
import io.opentelemetry.opencensusshim.OpenTelemetrySpanImpl;
import javax.annotation.Nullable;

final class SpanConverter {
    static final String MESSAGE_EVENT_ATTRIBUTE_KEY_TYPE = "message.event.type";
    static final String MESSAGE_EVENT_ATTRIBUTE_KEY_SIZE_UNCOMPRESSED = "message.event.size.uncompressed";
    static final String MESSAGE_EVENT_ATTRIBUTE_KEY_SIZE_COMPRESSED = "message.event.size.compressed";

    private SpanConverter() {
    }

    static SpanKind mapKind(@Nullable Span.Kind ocKind) {
        if (ocKind == null) {
            return SpanKind.INTERNAL;
        }
        switch (ocKind) {
            case CLIENT: {
                return SpanKind.CLIENT;
            }
            case SERVER: {
                return SpanKind.SERVER;
            }
        }
        return SpanKind.INTERNAL;
    }

    static io.opencensus.trace.Span fromOtelSpan(@Nullable Span otSpan) {
        if (otSpan == null) {
            return BlankSpan.INSTANCE;
        }
        return new OpenTelemetrySpanImpl(otSpan);
    }

    static io.opencensus.trace.SpanContext mapSpanContext(SpanContext otelSpanContext) {
        return io.opencensus.trace.SpanContext.create((TraceId)TraceId.fromLowerBase16((CharSequence)otelSpanContext.getTraceId()), (SpanId)SpanId.fromLowerBase16((CharSequence)otelSpanContext.getSpanId()), (TraceOptions)TraceOptions.builder().setIsSampled(otelSpanContext.isSampled()).build(), (Tracestate)SpanConverter.mapTracestate(otelSpanContext.getTraceState()));
    }

    static SpanContext mapSpanContext(io.opencensus.trace.SpanContext ocSpanContext) {
        return SpanContext.create((String)ocSpanContext.getTraceId().toLowerBase16(), (String)ocSpanContext.getSpanId().toLowerBase16(), (TraceFlags)(ocSpanContext.getTraceOptions().isSampled() ? TraceFlags.getSampled() : TraceFlags.getDefault()), (TraceState)SpanConverter.mapTracestate(ocSpanContext.getTracestate()));
    }

    private static TraceState mapTracestate(Tracestate tracestate) {
        TraceStateBuilder builder = TraceState.builder();
        tracestate.getEntries().forEach(entry -> builder.put(entry.getKey(), entry.getValue()));
        return builder.build();
    }

    static Tracestate mapTracestate(TraceState traceState) {
        Tracestate.Builder tracestateBuilder = Tracestate.builder();
        traceState.forEach((arg_0, arg_1) -> ((Tracestate.Builder)tracestateBuilder).set(arg_0, arg_1));
        return tracestateBuilder.build();
    }

    static Function<String, Void> setStringAttribute(AttributesBuilder builder, String key) {
        return arg -> {
            builder.put(key, arg);
            return null;
        };
    }

    static Function<Boolean, Void> setBooleanAttribute(AttributesBuilder builder, String key) {
        return arg -> {
            builder.put(key, arg.booleanValue());
            return null;
        };
    }

    static Function<Long, Void> setLongAttribute(AttributesBuilder builder, String key) {
        return arg -> {
            builder.put(key, arg.longValue());
            return null;
        };
    }

    static Function<Double, Void> setDoubleAttribute(AttributesBuilder builder, String key) {
        return arg -> {
            builder.put(key, arg.doubleValue());
            return null;
        };
    }
}

