/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace;

import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.trace.Event;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MessageEvent
implements Event {
    private static final String EVENT_NAME = "message";
    private static final String TYPE = "message.type";
    private static final String ID = "message.id";
    private static final String COMPRESSED_SIZE = "message.compressed_size";
    private static final String UNCOMPRESSED_SIZE = "message.uncompressed_size";
    private static final AttributeValue sentAttributeValue = AttributeValue.stringAttributeValue((String)Type.SENT.name());
    private static final AttributeValue receivedAttributeValue = AttributeValue.stringAttributeValue((String)Type.RECEIVED.name());
    private static final AttributeValue zeroAttributeValue = AttributeValue.longAttributeValue((long)0L);
    private final Attributes attributes;

    public static MessageEvent create(Type type, long messageId, long uncompressedSize, long compressedSize) {
        Attributes.Builder attributeBuilder = Attributes.newBuilder();
        attributeBuilder.setAttribute(TYPE, type == Type.SENT ? sentAttributeValue : receivedAttributeValue);
        attributeBuilder.setAttribute(ID, messageId == 0L ? zeroAttributeValue : AttributeValue.longAttributeValue((long)messageId));
        attributeBuilder.setAttribute(UNCOMPRESSED_SIZE, uncompressedSize == 0L ? zeroAttributeValue : AttributeValue.longAttributeValue((long)uncompressedSize));
        attributeBuilder.setAttribute(COMPRESSED_SIZE, compressedSize == 0L ? zeroAttributeValue : AttributeValue.longAttributeValue((long)compressedSize));
        return new MessageEvent(attributeBuilder.build());
    }

    public String getName() {
        return EVENT_NAME;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    private MessageEvent(Attributes attributes) {
        this.attributes = attributes;
    }

    public static enum Type {
        SENT,
        RECEIVED;

    }
}

