/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace;

import io.grpc.Context;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Status;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.concurrent.Callable;

public final class CurrentSpanUtils {
    private CurrentSpanUtils() {
    }

    public static Runnable withSpan(Span span, boolean endSpan, Runnable runnable) {
        return new RunnableInSpan(span, runnable, endSpan);
    }

    public static <C> Callable<C> withSpan(Span span, boolean endSpan, Callable<C> callable) {
        return new CallableInSpan(span, callable, endSpan);
    }

    private static void setErrorStatus(Span span, Throwable t) {
        span.setStatus(Status.UNKNOWN.withDescription(t.getMessage() == null ? t.getClass().getSimpleName() : t.getMessage()));
    }

    private static final class CallableInSpan<V>
    implements Callable<V> {
        private final Span span;
        private final Callable<V> callable;
        private final boolean endSpan;

        private CallableInSpan(Span span, Callable<V> callable, boolean endSpan) {
            this.span = span;
            this.callable = callable;
            this.endSpan = endSpan;
        }

        @Override
        public V call() throws Exception {
            Context origContext = TracingContextUtils.withSpan((Span)this.span, (Context)Context.current()).attach();
            try {
                V v = this.callable.call();
                return v;
            }
            catch (Exception e) {
                CurrentSpanUtils.setErrorStatus(this.span, e);
                throw e;
            }
            catch (Throwable t) {
                CurrentSpanUtils.setErrorStatus(this.span, t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new IllegalStateException("unexpected", t);
            }
            finally {
                Context.current().detach(origContext);
                if (this.endSpan) {
                    this.span.end();
                }
            }
        }
    }

    private static final class RunnableInSpan
    implements Runnable {
        private final Span span;
        private final Runnable runnable;
        private final boolean endSpan;

        private RunnableInSpan(Span span, Runnable runnable, boolean endSpan) {
            this.span = span;
            this.runnable = runnable;
            this.endSpan = endSpan;
        }

        @Override
        public void run() {
            Context origContext = TracingContextUtils.withSpan((Span)this.span, (Context)Context.current()).attach();
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                CurrentSpanUtils.setErrorStatus(this.span, t);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new IllegalStateException("unexpected", t);
            }
            finally {
                Context.current().detach(origContext);
                if (this.endSpan) {
                    this.span.end();
                }
            }
        }
    }
}

