/*
 * Decompiled with CFR 0.152.
 */
package io.openshift.booster.catalog.spi;

import io.openshift.booster.catalog.Booster;
import io.openshift.booster.catalog.spi.BoosterCatalogPathProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class NativeGitBoosterCatalogPathProvider
implements BoosterCatalogPathProvider {
    private static final Logger logger = Logger.getLogger(NativeGitBoosterCatalogPathProvider.class.getName());
    private static final String GITHUB_URL = "https://github.com/";
    private final String catalogRepositoryURI;
    private final String catalogRef;
    private final Path rootDir;

    public NativeGitBoosterCatalogPathProvider(String catalogRepositoryURI, String catalogRef, Path rootDir) {
        this.catalogRepositoryURI = catalogRepositoryURI;
        this.catalogRef = catalogRef;
        this.rootDir = rootDir;
    }

    @Override
    public Path createCatalogPath() throws IOException {
        logger.log(Level.INFO, "Indexing contents from {0} using {1} ref", new Object[]{this.catalogRepositoryURI, this.catalogRef});
        Path catalogPath = this.rootDir;
        if (catalogPath == null) {
            catalogPath = Files.createTempDirectory("booster-catalog", new FileAttribute[0]);
            logger.info("Created " + catalogPath);
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command("git", "clone", this.catalogRepositoryURI, "--branch", this.catalogRef, "--recursive", "--depth=1", "--quiet", catalogPath.toString()).inheritIO();
        logger.info("Executing: " + builder.command().stream().collect(Collectors.joining(" ")));
        try {
            int exitCode = builder.start().waitFor();
            assert (exitCode == 0) : "Process returned exit code: " + exitCode;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return catalogPath;
    }

    @Override
    public Path createBoosterContentPath(Booster booster) throws IOException {
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]).command("git", "clone", GITHUB_URL + booster.getGithubRepo(), "--branch", booster.getGitRef(), "--recursive", "--depth=1", booster.getContentPath().toString()).inheritIO();
            logger.info("Executing: " + builder.command().stream().collect(Collectors.joining(" ")));
            int exitCode = builder.start().waitFor();
            assert (exitCode == 0) : "Process returned exit code: " + exitCode;
            builder = new ProcessBuilder(new String[0]).command("git", "checkout", booster.getGitRef(), "--quiet").directory(booster.getContentPath().toFile()).inheritIO();
            logger.info("Executing: " + builder.command().stream().collect(Collectors.joining(" ")));
            exitCode = builder.start().waitFor();
            assert (exitCode == 0) : "Process returned exit code: " + exitCode;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted", e);
        }
        return booster.getContentPath();
    }
}

