/*
 * Decompiled with CFR 0.152.
 */
package io.openshift.booster.catalog.spi;

import io.openshift.booster.Files;
import io.openshift.booster.catalog.Booster;
import io.openshift.booster.catalog.spi.BoosterCatalogPathProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;

public class LocalBoosterCatalogPathProvider
implements BoosterCatalogPathProvider {
    private final URL catalogZipURL;
    private static final Logger logger = Logger.getLogger(LocalBoosterCatalogPathProvider.class.getName());

    public LocalBoosterCatalogPathProvider(URL catalogZip) {
        this.catalogZipURL = catalogZip;
    }

    @Override
    public Path createCatalogPath() throws IOException {
        Path catalogPath = java.nio.file.Files.createTempDirectory("booster-catalog", new FileAttribute[0]);
        logger.info("Unzipping booster contents to " + catalogPath);
        Path catalogPathZip = catalogPath.resolve("booster.zip");
        try (InputStream is = this.catalogZipURL.openStream();){
            java.nio.file.Files.copy(is, catalogPathZip, new CopyOption[0]);
        }
        Files.unzip(catalogPathZip, catalogPath);
        java.nio.file.Files.delete(catalogPathZip);
        return catalogPath;
    }

    @Override
    public Path createBoosterContentPath(Booster booster) throws IOException {
        throw new IllegalStateException("Could not find the content path for " + booster);
    }
}

