/*
 * Decompiled with CFR 0.152.
 */
package io.openshift.booster.catalog.spi;

import io.openshift.booster.catalog.Booster;
import io.openshift.booster.catalog.spi.BoosterCatalogPathProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

public class GitBoosterCatalogPathProvider
implements BoosterCatalogPathProvider {
    private static final Logger logger = Logger.getLogger(GitBoosterCatalogPathProvider.class.getName());
    private static final String GITHUB_URL = "https://github.com/";
    private final String catalogRepositoryURI;
    private final String catalogRef;
    private final Path rootDir;

    public GitBoosterCatalogPathProvider(String catalogRepositoryURI, String catalogRef, Path rootDir) {
        this.catalogRepositoryURI = catalogRepositoryURI;
        this.catalogRef = catalogRef;
        this.rootDir = rootDir;
    }

    @Override
    public Path createCatalogPath() throws IOException {
        logger.log(Level.INFO, "Indexing contents from {0} using {1} ref", new Object[]{this.catalogRepositoryURI, this.catalogRef});
        Path catalogPath = this.rootDir;
        if (catalogPath == null) {
            catalogPath = Files.createTempDirectory("booster-catalog", new FileAttribute[0]);
            logger.info("Created " + catalogPath);
        }
        try {
            Git.cloneRepository().setURI(this.catalogRepositoryURI).setBranch(this.catalogRef).setCloneSubmodules(true).setDirectory(catalogPath.toFile()).call().close();
        }
        catch (GitAPIException e) {
            throw new IOException("Error while performing Git operation", e);
        }
        return catalogPath;
    }

    @Override
    public Path createBoosterContentPath(Booster booster) throws IOException {
        try (Git git = Git.cloneRepository().setDirectory(booster.getContentPath().toFile()).setURI(GITHUB_URL + booster.getGithubRepo()).setCloneSubmodules(true).setBranch(booster.getGitRef()).call();){
            git.checkout().setName(booster.getGitRef()).setStartPoint(booster.getGitRef()).call();
        }
        catch (GitAPIException e) {
            throw new IOException("Error while reading git repository", e);
        }
        return booster.getContentPath();
    }
}

